/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.proxy.provider;

import ca.uhn.fhir.util.ElementUtil;
import java.util.Date;
import java.util.UUID;
import java.util.function.Function;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Resource;

/**
 *
 * @author PII
 */
public interface ResourceProvider<T extends Resource>
{
    default Long create(T resource)
    {
        if (!resource.hasIdElement()) {
            resource.setIdElement(new IdType(resource.fhirType(), UUID.randomUUID().toString()));
        }
        resource.getMeta().setLastUpdated(new Date());
        resource.getMeta().setVersionId("0");
        return -1L;
    }
    
    T read(Long id);
    
    default T readAndLock(Long id)
    {
        return read(id);
    }
    
    default boolean readWithUpdate(Long id, Function<T, Boolean> function)
    {
        boolean ret = false;
        T resource = readAndLock(id);
        if (resource != null) {
            ret = function.apply(resource);
            if (ret) {
                update(id, resource);
            }
        }
        return ret;
    }
    
    T read(IdType id);
    
    default void update(Long id, T resource)
    {
        Date d = new Date();
        resource.getMeta().setLastUpdated(d);
        
        String versionID = resource.getMeta().getVersionId();
        if (ElementUtil.isEmpty(versionID)) {
            versionID = "1";
        }
        else {
            versionID = Integer.toString(Integer.parseInt(versionID) + 1);
        }
        resource.getMeta().setVersionId(versionID);
    }
    
    T delete(Long id);
}
