/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.proxy.documentretrieve;

import com.sun.xml.ws.client.BindingProviderProperties;
import gov.hhs.fha.nhinc.common.nhinccommon.AssertionType;
import gov.hhs.fha.nhinc.common.nhinccommon.CeType;
import gov.hhs.fha.nhinc.common.nhinccommon.HomeCommunityType;
import gov.hhs.fha.nhinc.common.nhinccommon.PersonNameType;
import gov.hhs.fha.nhinc.common.nhinccommon.UserType;
import gov.hhs.fha.nhinc.common.nhinccommonentity.RespondingGatewayCrossGatewayRetrieveRequestType;
import gov.hhs.fha.nhinc.entitydocretrieve.EntityDocRetrieve;
import gov.hhs.fha.nhinc.entitydocretrieve.EntityDocRetrievePortType;
import gov.va.med.nhin.adapter.subscription.web.annotations.Property;
import gov.va.med.nhin.adapter.subscription.web.dao.FacilityDAO;
import gov.va.med.nhin.adapter.subscription.web.entity.Facility;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXDocumentReference;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXSubscription;
import ihe.iti.xds_b._2007.RetrieveDocumentSetRequestType;
import ihe.iti.xds_b._2007.RetrieveDocumentSetRequestType.DocumentRequest;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponseType;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponseType.DocumentResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.hl7.fhir.dstu3.model.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryError;
import org.hl7.fhir.dstu3.model.IdType;

/**
 *
 * @author david
 */
@Named("WSDocumentRetriever")
@ApplicationScoped()
public class WSDocumentRetriever implements DocumentRetriever
{
    private static final Logger logger = LoggerFactory.getLogger(WSDocumentRetriever.class);
    
    private EntityDocRetrieve entityDocRetrieve;

    @Inject
    @Property
    private String entityDocRetrieveWSDL;

    @Inject
    @Property(defaultValue = "30000")
    private int entityDocRetrieveServiceConnectTimeout;
    
    @Inject
    @Property(defaultValue = "300000")
    private int entityDocRetrieveServiceRequestTimeout;
    
    @Inject
    @Property
    private String vaAssigningAuthorityID;

    @Inject
    private FacilityDAO facilityDAO;

    @Override
    public DocumentRetrieverResponse sendRetrieveDocument(EHXDocumentReference documentReference, EHXSubscription.Assertions assertions)
    {
        Binary binary;
        List<String> errors;
        boolean success;
        
        logger.debug("Starting Document Retrieve for patient: " + documentReference.getPatientID() + " at " + documentReference.getHomeCommunityId() + " and Document ID: " + documentReference.getDocumentUniqueId());
        
        try {
            RespondingGatewayCrossGatewayRetrieveRequestType request
                = buildRequest(documentReference, assertions);
            RetrieveDocumentSetResponseType response = getPort().respondingGatewayCrossGatewayRetrieve(request);
            binary = extractBinaryFromRetrieveDocumentSetResponse(response, documentReference);
            errors = extractErrorsFromRetrieveDocumentSetResponse(response);
            success = binary != null || errors.isEmpty();
        }
        catch (WebServiceException wse) {
            binary = null;
            errors = new ArrayList<>();
            errors.add("Failed to invoke call to EntityDocRetrieve service - " + wse.getMessage() + "for patient: " + documentReference.getPatientID() + " at " + documentReference.getHomeCommunityId() + " and Document ID: " + documentReference.getDocumentUniqueId());
            success = false;
            logger.warn("Failed to invoke call to EntityDocRetrieve", wse);
        }
        catch (IOException ioe) {
            binary = null;
            errors = new ArrayList<>();
            errors.add("Error extracting document from response - " + ioe.getMessage() + "for patient: " + documentReference.getPatientID() + " at " + documentReference.getHomeCommunityId() + " and Document ID: " + documentReference.getDocumentUniqueId());
            success = false;
            logger.warn("Error extracting document from response", ioe);
        }
        catch (Throwable t) {
            binary = null;
            errors = new ArrayList<>();
            errors.add("WSDocumentRetriever Internal server error - look in logs for the details - " + t.getLocalizedMessage() + "for patient: " + documentReference.getPatientID() + " at " + documentReference.getHomeCommunityId() + " and Document ID: " + documentReference.getDocumentUniqueId());
            success = false;
            logger.error("WSDocumentRetriever Internal server error", t);
        }
        logger.debug("Returning Document Retrieve Response for patient: " + documentReference.getPatientID() + " at " + documentReference.getHomeCommunityId() + " and Document ID: " + documentReference.getDocumentUniqueId());
        return new DocumentRetrieverResponse(binary, errors, success);
    }

    private RespondingGatewayCrossGatewayRetrieveRequestType buildRequest(EHXDocumentReference documentReference,
                                                                          EHXSubscription.Assertions assertions)
    {
        RespondingGatewayCrossGatewayRetrieveRequestType ret = new RespondingGatewayCrossGatewayRetrieveRequestType();
        ret.setAssertion(buildAssertion(documentReference.getPatientID(), assertions));
        ret.setRetrieveDocumentSetRequest(buildRetrieveDocumentSetRequest(documentReference));
        return ret;
    }

    private RetrieveDocumentSetRequestType buildRetrieveDocumentSetRequest(EHXDocumentReference documentReference)
    {
        RetrieveDocumentSetRequestType ret = new RetrieveDocumentSetRequestType();
        ret.getDocumentRequest().add(buildDocumentRequest(documentReference));
        return ret;
    }

    private DocumentRequest buildDocumentRequest(EHXDocumentReference documentReference)
    {
        DocumentRequest ret = new DocumentRequest();
        ret.setHomeCommunityId(documentReference.getHomeCommunityId());
        ret.setRepositoryUniqueId(documentReference.getRepositoryUniqueId());
        ret.setDocumentUniqueId(documentReference.getDocumentUniqueId());
        return ret;
    }

    /*
        build Assertion
     */
    private AssertionType buildAssertion(String patientID, EHXSubscription.Assertions assertions)
    {
        AssertionType ret = new AssertionType();
        Facility homeFacility = getHomeFacility();

        ret.setAuthorized(true);

        HomeCommunityType homeCommunity = new HomeCommunityType();
        homeCommunity.setHomeCommunityId(homeFacility.getFullHomeCommunityId());
        homeCommunity.setName(homeFacility.getFacilityName());
        ret.setHomeCommunity(homeCommunity);

        UserType user = new UserType();
        user.setPersonName(buildPersonName(assertions.getUserName().asStringValue()));
        user.setUserName(assertions.getUserID().asStringValue());
        HomeCommunityType userOrganization = new HomeCommunityType();
        userOrganization.setHomeCommunityId(assertions.getOrganizationID().asStringValue());
        userOrganization.setName(assertions.getOrganizationName().asStringValue());
        userOrganization.setDescription(assertions.getSystemID().asStringValue());
        user.setOrg(userOrganization);
        CeType roleCoded = new CeType();
        roleCoded.setCode(assertions.getRole().asStringValue());
        user.setRoleCoded(roleCoded);
        ret.setUserInfo(user);

        CeType pouCoded = new CeType();
        pouCoded.setCode(assertions.getPurposeOfUse().asStringValue());
        ret.setPurposeOfDisclosureCoded(pouCoded);

        ret.getUniquePatientId().add(patientID + "^^^&" + vaAssigningAuthorityID + "&ISO");

        return ret;
    }

    private PersonNameType buildPersonName(String username)
    {
        PersonNameType ret = new PersonNameType();
        String[] parts = username.split(" ");

        ret.setGivenName(parts[0]);
        ret.setFamilyName(parts[parts.length - 1]);
        ret.setFullName(username);

        return ret;
    }

    /*
        get the porttype for EntityDocRetrieve
     */
    private synchronized EntityDocRetrievePortType getPort() throws MalformedURLException
    {
        if (entityDocRetrieve == null) {
            entityDocRetrieve = new EntityDocRetrieve(new URL(entityDocRetrieveWSDL));
        }

        EntityDocRetrievePortType ret = entityDocRetrieve.getPort(new QName("urn:gov:hhs:fha:nhinc:entitydocretrieve", "EntityDocRetrievePortSoap11"), EntityDocRetrievePortType.class);

        // set request and connect timeouts on port.
        Map<String, Object> requestContext = ((BindingProvider)ret).getRequestContext();
        requestContext.put(BindingProviderProperties.REQUEST_TIMEOUT, entityDocRetrieveServiceRequestTimeout);
        requestContext.put(BindingProviderProperties.CONNECT_TIMEOUT, entityDocRetrieveServiceConnectTimeout);

        return ret;
    }

    private Binary extractBinaryFromRetrieveDocumentSetResponse(RetrieveDocumentSetResponseType response, EHXDocumentReference documentReference)
        throws IOException
    {
        Binary ret;
        
        if (!response.getDocumentResponse().isEmpty()) {
            ret = extractContentFromDocumentResponse(response.getDocumentResponse().get(0));
            ret.setIdElement(new IdType(ret.fhirType(), documentReference.getIdElement().getIdPart()));
        }
        else {
            ret = null;
        }
        
        return ret;
    }

    public Binary extractContentFromDocumentResponse(DocumentResponse documentResponse)
        throws IOException
    {
        Binary ret;
        if (documentResponse.getDocument() != null) {
            ret = new Binary();
            ret.setContentType(documentResponse.getMimeType());
            DataHandler dh = documentResponse.getDocument();
            byte[] buffer = new byte[4096];

            ByteArrayOutputStream baos = new ByteArrayOutputStream();

            try (InputStream in = dh.getInputStream()) {
                int size;
                do {
                    size = in.read(buffer);
                    if (size > 0) {
                        baos.write(buffer, 0, size);
                    }
                }
                while (size == buffer.length);
            }

            ret.setContent(baos.toByteArray());
        }
        else {
            ret = null;
        }
        
        return ret;
    }

    public List<String> extractErrorsFromRetrieveDocumentSetResponse(RetrieveDocumentSetResponseType resp)
    {
        List<String> ret = new ArrayList<>();
        
        if (resp.getRegistryResponse() != null
            && resp.getRegistryResponse().getRegistryErrorList() != null
            && !resp.getRegistryResponse().getRegistryErrorList().getRegistryError().isEmpty()) {
            for (RegistryError re : resp.getRegistryResponse().getRegistryErrorList().getRegistryError()) {
                ret.add(String.format("%s - %s - %s - %s - %s",
                                      re.getLocation(),
                                      re.getSeverity(),
                                      re.getErrorCode(),
                                      re.getCodeContext(),
                                      re.getValue()));
                        
            }
        }
        
        return ret;
    }
    
    public void setEntityDocRetrieveWSDL(String entityDocRetrieveWSDL)
    {
        this.entityDocRetrieveWSDL = entityDocRetrieveWSDL;
    }

    private Facility getHomeFacility()
    {
        return facilityDAO.findByFacilityNumber("VA");
    }

    public void setEntityDocRetrieve(EntityDocRetrieve entityDocRetrieve)
    {
        this.entityDocRetrieve = entityDocRetrieve;
    }

    public void setVaAssigningAuthorityID(String vaAssigningAuthorityID)
    {
        this.vaAssigningAuthorityID = vaAssigningAuthorityID;
    }

    public void setFacilityDAO(FacilityDAO facilityDAO)
    {
        this.facilityDAO = facilityDAO;
    }
}
