/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.proxy.correlationretriever;

import com.sun.xml.ws.client.BindingProviderProperties;
import gov.hhs.fha.nhinc.common.nhinccommon.AssertionType;
import gov.hhs.fha.nhinc.common.nhinccommon.CeType;
import gov.hhs.fha.nhinc.common.nhinccommon.HomeCommunityType;
import gov.hhs.fha.nhinc.common.nhinccommon.PersonNameType;
import gov.hhs.fha.nhinc.common.nhinccommon.UserType;
import gov.hhs.fha.nhinc.nhinccomponentpatientcorrelation.PatientCorrelationPortType;
import gov.hhs.fha.nhinc.nhinccomponentpatientcorrelation.PatientCorrelationService;
import gov.hhs.fha.nhinc.transform.subdisc.HL7PRPA201309Transforms;
import gov.va.med.nhin.adapter.subscription.web.annotations.Property;
import gov.va.med.nhin.adapter.subscription.web.dao.FacilityDAO;
import gov.va.med.nhin.adapter.subscription.web.entity.Facility;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXSubscription;
import gov.va.med.nhin.adapter.subscription.web.utils.logging.Log;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.ws.BindingProvider;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.v3.II;
import org.hl7.v3.PRPAIN201310UV02;
import org.hl7.v3.PRPAMT201304UV02Patient;
import org.hl7.v3.RetrievePatientCorrelationsRequestType;
import org.hl7.v3.RetrievePatientCorrelationsResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author david
 */
@ApplicationScoped()
public class WSCorrelationRetriever implements CorrelationRetriever
{
    private static final Logger logger = LoggerFactory.getLogger(WSCorrelationRetriever.class);
    
    private PatientCorrelationService patientCorrelationService;
    @Inject
    private FacilityDAO facilityDAO;

    @Inject
    @Property
    private String vaAssigningAuthorityID;

    @Inject
    @Property
    private String adapterPatientCorrelationServiceWSDL;

    @Inject
    @Property(defaultValue = "30000")
    private int adapterPatientCorrelationServiceConnectTimeout;

    @Inject
    @Property(defaultValue = "30000")
    private int adapterPatientCorrelationServiceRequestTimeout;
    
    @Override
    public List<Identifier> getCorrelations(String patientID, EHXSubscription.Assertions assertions)
    {
        Log.debug(logger, "Retrieving Correlations for Patient: " + patientID);
        List<Identifier> ret;
        
        RetrievePatientCorrelationsRequestType request = buildRequest(patientID, assertions);
        RetrievePatientCorrelationsResponseType response = getPort().retrievePatientCorrelations(request);
        ret = extractIdentifiersFromRetrievePatientCorrelationsResponse(response);
        return ret;
    }

    private RetrievePatientCorrelationsRequestType buildRequest(String patientID, EHXSubscription.Assertions assertions)
    {
        RetrievePatientCorrelationsRequestType ret = new RetrievePatientCorrelationsRequestType();
        ret.setPRPAIN201309UV02(HL7PRPA201309Transforms.createPRPA201309(vaAssigningAuthorityID, patientID));
        ret.setAssertion(buildAssertion(patientID, assertions));
        return ret;
    }
    
    private AssertionType buildAssertion(String patientID, EHXSubscription.Assertions assertions)
    {
        AssertionType ret = new AssertionType();
        Facility homeFacility = getHomeFacility();

        ret.setAuthorized(true);

        HomeCommunityType homeCommunity = new HomeCommunityType();
        homeCommunity.setHomeCommunityId(homeFacility.getFullHomeCommunityId());
        homeCommunity.setName(homeFacility.getFacilityName());
        ret.setHomeCommunity(homeCommunity);

        UserType user = new UserType();
        user.setPersonName(buildPersonName(assertions.getUserName().asStringValue()));
        user.setUserName(assertions.getSystemID().asStringValue() + ":" + assertions.getUserID().asStringValue());
        HomeCommunityType userOrganization = new HomeCommunityType();
        userOrganization.setHomeCommunityId(assertions.getOrganizationID().asStringValue());
        userOrganization.setName(assertions.getOrganizationName().asStringValue());
        user.setOrg(userOrganization);
        CeType roleCoded = new CeType();
        roleCoded.setCode(assertions.getRole().asStringValue());
        user.setRoleCoded(roleCoded);
        ret.setUserInfo(user);

        CeType pouCoded = new CeType();
        pouCoded.setCode(assertions.getPurposeOfUse().asStringValue());
        ret.setPurposeOfDisclosureCoded(pouCoded);

        ret.getUniquePatientId().add(patientID + "^^^&" + vaAssigningAuthorityID + "&ISO");

        return ret;
    }
    
    private PersonNameType buildPersonName(String username)
    {
        PersonNameType ret = new PersonNameType();
        String[] parts = username.split(" ");

        ret.setGivenName(parts[0]);
        ret.setFamilyName(parts[parts.length - 1]);
        ret.setFullName(username);

        return ret;
    }
    
    private synchronized PatientCorrelationPortType getPort()
    {
        try {
            if (patientCorrelationService == null) {
                patientCorrelationService = new PatientCorrelationService(new URL(adapterPatientCorrelationServiceWSDL));
            }

            PatientCorrelationPortType ret = patientCorrelationService.getPatientCorrelationPort();

            // set request and connect timeouts on port.
            Map<String, Object> requestContext = ((BindingProvider)ret).getRequestContext();
            requestContext.put(BindingProviderProperties.REQUEST_TIMEOUT, adapterPatientCorrelationServiceRequestTimeout);
            requestContext.put(BindingProviderProperties.CONNECT_TIMEOUT, adapterPatientCorrelationServiceConnectTimeout);
            
            return ret;
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException("patientCorrelationWSDL is not set to a valid URL.  Fix the configuration.", mue);
        }
    }
    
    private List<Identifier> extractIdentifiersFromRetrievePatientCorrelationsResponse(RetrievePatientCorrelationsResponseType response)
    {
        List<Identifier> ret = new ArrayList<>();
        PRPAMT201304UV02Patient patient = extractPatient(response.getPRPAIN201310UV02());
        if (patient != null) {
            for (II i : patient.getId()) {
                Identifier id = new Identifier();
                id.setSystem(i.getRoot());
                id.setValue(i.getExtension());
                ret.add(id);
            }
        }
        return ret;
    }
    
    private PRPAMT201304UV02Patient extractPatient(PRPAIN201310UV02 prpain201310UV02)
    {
        PRPAMT201304UV02Patient ret = null;

        if (prpain201310UV02.getControlActProcess() != null
            && !prpain201310UV02.getControlActProcess().getSubject().isEmpty()
            && prpain201310UV02.getControlActProcess().getSubject().get(0).getRegistrationEvent() != null
            && prpain201310UV02.getControlActProcess().getSubject().get(0).getRegistrationEvent().getSubject1() != null
            && prpain201310UV02.getControlActProcess().getSubject().get(0).getRegistrationEvent().getSubject1().getPatient() != null) {
            ret = prpain201310UV02.getControlActProcess().getSubject().get(0).getRegistrationEvent().getSubject1().getPatient();
        }

        return ret;
    }
    
    private Facility getHomeFacility()
    {
        return facilityDAO.findByFacilityNumber("VA");
    }
}
