/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.proxy.announce;

import com.sun.xml.ws.client.BindingProviderProperties;
import gov.va.med.nhin.adapter.announcepatient.AnnouncePatientPortType;
import gov.va.med.nhin.adapter.announcepatient.AnnouncePatientResponseType;
import gov.va.med.nhin.adapter.announcepatient.AnnouncePatientService;
import gov.va.med.nhin.adapter.announcepatient.AnnouncePatientType;
import gov.va.med.nhin.adapter.permission.UserInfoType;
import gov.va.med.nhin.adapter.subscription.web.annotations.Property;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXSubscription;
import gov.va.med.nhin.adapter.subscription.web.utils.logging.Log;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author david
 */
@Named("WSPatientAnnouncer")
@ApplicationScoped()
public class WSPatientAnnouncer implements PatientAnnouncer
{
    static private final Logger logger = LoggerFactory.getLogger(WSPatientAnnouncer.class.getName());
    
    private AnnouncePatientService announcePatientService;

    @Inject
    @Property
    private String announcePatientServiceWSDL;

    @Inject
    @Property(defaultValue = "30000")
    private int announcePatientServiceConnectTimeout;
    
    @Inject
    @Property(defaultValue = "300000")
    private int announcePatientServiceRequestTimeout;
   
    @Override
    public int sendAnnouncePatient(String forPatientId,
                                   String nhioHCID,
                                   EHXSubscription.Assertions assertions)
    {
        int ret;
        Log.debug(logger, "Sending Announce Patient for patientID:" + forPatientId + " and nhioHCID: " +  nhioHCID);
        try {
            AnnouncePatientType request = buildRequest(forPatientId, nhioHCID, assertions);
            AnnouncePatientResponseType response = getPort().announcePatient(request);
            ret = response.getReturn();
        }
        catch (WebServiceException wse) {
            ret = -1;
            logger.warn("Failed to invoke call to AnnouncePatient service.", wse);
        }
        catch (Throwable t) {
            ret = -999;
            logger.error("WSPatientAnnouncer internal error.", t);
        }
        
        Log.debug(logger, "Announce for patientID: " + forPatientId + " at " + nhioHCID + " returned with response value: " + ret);
        return ret;
    }

    private AnnouncePatientType buildRequest(String patientId,
                                             String hcid,
                                             EHXSubscription.Assertions assertions)
    {
        AnnouncePatientType ret = new AnnouncePatientType();
        
        ret.setPatientId(patientId);
        
        AnnouncePatientType.Facilities facilities = new AnnouncePatientType.Facilities();
        facilities.getFacility().add(hcid);
        ret.setFacilities(facilities);
        
        UserInfoType userInfo = new UserInfoType();
        userInfo.setUserId(assertions.getUserID().getValue());
        userInfo.setFullName(assertions.getUserName().getValue());
        userInfo.setAuthenticationMethod("Password");
        userInfo.setSystemId(assertions.getSystemID().getValue());
        userInfo.setRole(assertions.getRole().getValue());
        ret.setUserInfo(userInfo);
        
        return ret;
    }

    private synchronized AnnouncePatientPortType getPort() throws MalformedURLException
    {
        if (announcePatientService == null) {
            URL url = new URL(announcePatientServiceWSDL);
            QName qname = new QName("urn:gov:va:med:nhin:adapter:announcepatient", "AnnouncePatientService");
            announcePatientService = new AnnouncePatientService(url, qname);
        }
        
        AnnouncePatientPortType ret = announcePatientService.getAnnouncePatientPort();
        
        // set request and connect timeouts on port.
        Map<String, Object> requestContext = ((BindingProvider)ret).getRequestContext();
        requestContext.put(BindingProviderProperties.REQUEST_TIMEOUT, announcePatientServiceRequestTimeout);
        requestContext.put(BindingProviderProperties.CONNECT_TIMEOUT, announcePatientServiceConnectTimeout);

        return ret;
    }

    public void setAnnouncePatientServiceWSDL(String announcePatientServiceWSDL)
    {
        this.announcePatientServiceWSDL = announcePatientServiceWSDL;
    }
}
