/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.process;

import gov.va.med.nhin.adapter.subscription.web.annotations.Updated;
import gov.va.med.nhin.adapter.subscription.web.event.NHIOEvent;
import gov.va.med.nhin.adapter.subscription.web.event.NotificationEvent;
import gov.va.med.nhin.adapter.subscription.web.proxy.provider.subscription.SubscriptionProvider;
import gov.va.med.nhin.adapter.subscription.web.utils.logging.Log;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.hl7.fhir.dstu3.model.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author david_vetsez
 */
@ApplicationScoped
public class SubscriptionUpdateProcessor
{
    private static final Logger logger = LoggerFactory.getLogger(SubscriptionProcessor.class);
    
    @Inject
    private SubscriptionProvider subscriptionProvider;
    @Inject
    private Event<NotificationEvent> notificationEvent;
    
    public void processSubscriptionUpdate(@Observes @Updated NHIOEvent event)
    {
        //boolean forceNotification = subscriptionProvider.readWithUpdate(event.getSubscriptionID(), (subscription) -> {
        subscriptionProvider.readWithUpdate(event.getSubscriptionID(), (subscription) -> {
            // 'forceNotification' is an unused var. so, removed   
        boolean ret = true;
        
            // update the status of the NHIO in the subscription.
            subscription.updateNHIOStatus(event.getHCID(), event.getStatus(), event.getProcessingStage(), event.getErrors());
            
            if (subscription.getStatus() == Subscription.SubscriptionStatus.ACTIVE) {
                // turn off subscription when all NHIOs have completed processing.
                if (subscription.allDone()) {
                    subscription.setStatus(Subscription.SubscriptionStatus.OFF);
                    Log.debug(logger, "Subscription Status Updated to 'OFF' for SubscriptionID " + subscription.getId());
                }
            }
            
            return ret;
        });
        
        notificationEvent.fire(new NotificationEvent(event.getSubscriptionID(), event));
        //TODO: how do I log this notification event?
    }

    public void setSubscriptionProvider(SubscriptionProvider subscriptionProvider)
    {
        this.subscriptionProvider = subscriptionProvider;
    }

    public void setNotificationEvent(Event<NotificationEvent> notificationEvent)
    {
        this.notificationEvent = notificationEvent;
    }
}
