/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.process;

import gov.va.med.nhin.adapter.subscription.web.event.NotificationEvent;
import gov.va.med.nhin.adapter.subscription.web.proxy.provider.subscription.SubscriptionProvider;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXSubscription;
import gov.va.med.nhin.adapter.subscription.web.utils.logging.Log;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation.Builder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.hl7.fhir.dstu3.model.StringType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author david_vetsez
 */
@ApplicationScoped
public class RestHookNotificationProcessor
{
    private static final Logger logger = LoggerFactory.getLogger(RestHookNotificationProcessor.class);
        
    @Inject
    private SubscriptionProvider subscriptionProvider;
    
    public void processNotification(NotificationEvent event)
    {
       
        EHXSubscription subscription = subscriptionProvider.read(event.getSubscriptionID());
        Client client = ClientBuilder.newClient();
        client.register(EntityLoggingFilter.class);
        WebTarget target = client.target(subscription.getChannel().getEndpoint());
        Builder builder = target.request();

        // insert headers requested by subscriber into HTTP notification.
        for (StringType header : subscription.getChannel().getHeader()) {
            String s = header.getValue();
            String[] a = s.split(":");
            builder.header(a[0].trim(), a[1].trim());
        }
        Log.debug(logger, "Notification with Subscription ID: " + event.getSubscriptionID() + " preparing to send to: " + target.getUri() );
        
        Response response = builder.build("POST").invoke();
        Log.info(logger, "Response from notification with subscription ID: " + event.getSubscriptionID() + " Status code: " + response.getStatus() + " Headers: "+ response.getStringHeaders());
        response.close();
        client.close();
    }

    public void setSubscriptionProvider(SubscriptionProvider subscriptionProvider)
    {
        this.subscriptionProvider = subscriptionProvider;
    }
}
