/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.process;

import ca.uhn.fhir.util.ElementUtil;

import gov.va.med.nhin.adapter.subscription.web.annotations.Property;
import gov.va.med.nhin.adapter.subscription.web.event.NotificationEvent;
import gov.va.med.nhin.adapter.subscription.web.proxy.provider.subscription.SubscriptionProvider;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXSubscription;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXSubscription.NHIOStatus.StatusType;
import gov.va.med.nhin.adapter.subscription.web.utils.logging.Log;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import static org.hl7.fhir.dstu3.model.Subscription.SubscriptionChannelType.RESTHOOK;
import static org.hl7.fhir.dstu3.model.Subscription.SubscriptionChannelType.WEBSOCKET;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author david
 */
@Stateless()
@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
public class NotificationEventProcessor
{
    private static final Logger logger = LoggerFactory.getLogger(NotificationEventProcessor.class);
    
    @Inject
    private SubscriptionProvider subscriptionProvider;
    @Inject
    private RestHookNotificationProcessor restHookNotificationProcessor;
    @Inject
    private WebSocketNotificationProcessor webSocketNotificationProcessor;
    @Inject
    @Property
    private boolean notifyAll;
    
    @Asynchronous
    public void fireEvent(@Observes NotificationEvent notificationEvent)
    {
        if (notifyClients(notificationEvent)) {
            EHXSubscription subscription = subscriptionProvider.read(notificationEvent.getSubscriptionID());
            switch (subscription.getChannel().getType()) {
                case RESTHOOK:
                    if (!ElementUtil.isEmpty(subscription.getChannel().getEndpoint())) {
                        restHookNotificationProcessor.processNotification(notificationEvent);
                    }
                    Log.debug(logger, "Subscription Notification utilizing Rest Hook");
                    break;

                case WEBSOCKET:
                    webSocketNotificationProcessor.processNotification(notificationEvent);
                    Log.debug(logger, "Subscription Notification utilizing WebSockets");
                    break;

                default:
                    break;
            }
        }
    }
    
    private boolean notifyClients(NotificationEvent notificationEvent)
    {
        return notifyAll
               || notificationEvent.getForceNotification()
               || (notificationEvent.getNHIOEvent() != null
                   && (notificationEvent.getNHIOEvent().getForceNotification()
                       || notificationEvent.getNHIOEvent().getStatus() == StatusType.DONE));
    }
}
