/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.process;

import gov.va.med.nhin.adapter.subscription.web.proxy.documentretrieve.DocumentRetriever;
import gov.va.med.nhin.adapter.subscription.web.proxy.documentretrieve.DocumentRetrieverResponse;
import gov.va.med.nhin.adapter.subscription.web.proxy.provider.binary.BinaryProvider;
import gov.va.med.nhin.adapter.subscription.web.proxy.provider.documentreference.DocumentReferenceProvider;
import gov.va.med.nhin.adapter.subscription.web.proxy.provider.subscription.SubscriptionProvider;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXDocumentReference;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXSubscription;
import gov.va.med.nhin.adapter.subscription.web.utils.logging.Log;
import java.util.Arrays;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.LockTimeoutException;
import org.hl7.fhir.dstu3.model.Binary;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.IdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author PII
 */
@Named("DocumentProcessor")
@ApplicationScoped()
public class DocumentProcessor
{
    private static final Logger logger = LoggerFactory.getLogger(DocumentProcessor.class);
        
    @Inject
    private BinaryProvider binaryProvider;
    @Inject
    private DocumentReferenceProvider documentReferenceProvider;
    @Inject
    private SubscriptionProvider subscriptionProvider;
    @Inject
    private DocumentRetriever documentRetriever;

    public DocumentRetrieverResponse getDocument(String documentID)
    {  
        Log.debug(logger, "DocumentProcessor: Attempting to retrieve Document with ID: " + documentID);
        DocumentRetrieverResponse ret = null;
        IdType documentReferenceID = new IdType("DocumentReference", documentID);
        EHXDocumentReference documentReference = documentReferenceProvider.read(documentReferenceID);
        if (documentReference != null) {
            ret = getDocument(documentReference);
        }
        //Log.debug(logger, "DocumentProcessor: Document "+documentID+" for "+ documentReference.getPatientID() +" at "+ documentReference.getHomeCommunityId() +" returned: " + ret.isSuccess());
        Log.debug(logger, "DocumentProcessor: Document "+documentID+" for "+ (documentReference !=null ? documentReference.getPatientID() : null )+" at "+ (documentReference!= null ? documentReference.getHomeCommunityId() :null )+" returned: " + (ret != null ? ret.isSuccess(): null ) );
        return ret;
    }

    public DocumentRetrieverResponse getDocument(EHXDocumentReference documentReference)
    {
        
        Long documentReferenceID = (Long)documentReference.getUserData("documentReferenceID");
        Log.debug(logger, "DocumentProcessor: Attempting to retrieve Document "+documentReferenceID+" for "+ documentReference.getPatientID() +" at "+ documentReference.getHomeCommunityId());
        
        final DocumentRetrieverResponse[] ret = new DocumentRetrieverResponse[1];
        try {
            documentReferenceProvider.readWithUpdate(documentReferenceID, (dr) -> { 
                boolean updatedRecord = false;
                IdType binaryID = new IdType("Binary", dr.getIdElement().getIdPart());
                Binary binary = binaryProvider.read(binaryID);
                if (binary == null) {
                    EHXSubscription subscription = subscriptionProvider.read(new IdType(dr.getSubscription().getReference()));
                    ret[0] = documentRetriever.sendRetrieveDocument(dr, subscription.getAssertions());
                    if (ret[0].getBinary() != null) {
                        dr.setDocumentRetrieved(new BooleanType(true));
                        binaryProvider.create(ret[0].getBinary());
                        updatedRecord = true;
                        Log.info(logger, "DocumentProcessor: Document Retriever Response was successful for Document "+documentReferenceID+" for "+ documentReference.getPatientID() +" at "+ documentReference.getHomeCommunityId());
                    }
                }
                else {
                    ret[0] = new DocumentRetrieverResponse(binary);
                }
                return updatedRecord;
            });
        }
        catch (LockTimeoutException lte) {
            ret[0] = new DocumentRetrieverResponse(null, Arrays.asList(new String[]{"Unable to get databsae lock."}), false);
        }
        return ret[0];
    }
}
