/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.event;
/**
 *
 * @author david_vetsez
 */
public class NotificationEvent extends Event
{
    private final Long subscriptionID;
    private final boolean forceNotification;
    private final NHIOEvent nhioEvent;
    
    public NotificationEvent(Long subscriptionID)
    {
        this(subscriptionID, null, false);
    }
    
    public NotificationEvent(Long subscriptionID, boolean forceNotification)
    {
        this(subscriptionID, null, forceNotification);
    }
    
    public NotificationEvent(Long subscriptionID, NHIOEvent nhioEvent)
    {
        this(subscriptionID, nhioEvent, false);
    }
    
    public NotificationEvent(Long subscriptionID, NHIOEvent nhioEvent, boolean forceNotification)
    {
        this.subscriptionID = subscriptionID;
        this.nhioEvent = nhioEvent;
        this.forceNotification = forceNotification;
    }

    public Long getSubscriptionID()
    {
        return subscriptionID;
    }

    public NHIOEvent getNHIOEvent()
    {
        return nhioEvent;
    }
    
    public boolean getForceNotification()
    {
        return forceNotification;
    }
}
