/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.event;

import gov.va.med.nhin.adapter.subscription.web.resource.EHXSubscription;
import java.util.List;
/**
 *
 * @author david_vetsez
 */
public class NHIOEvent extends Event
{
    private final Long subscriptionID;
    private final String hcid;
    private final EHXSubscription.NHIOStatus.ProcessingStageType processingStage;
    private final EHXSubscription.NHIOStatus.StatusType status;
    private final List<String> errors;
    private final boolean forceNotification;

    public NHIOEvent(Long subscriptionID, String hcid, EHXSubscription.NHIOStatus.StatusType status, EHXSubscription.NHIOStatus.ProcessingStageType processingStage)
    {
        this(subscriptionID, hcid, status, processingStage, false, null);
    }

    public NHIOEvent(Long subscriptionID, String hcid, EHXSubscription.NHIOStatus.StatusType status, EHXSubscription.NHIOStatus.ProcessingStageType processingStage, boolean forceNotification)
    {
        this(subscriptionID, hcid, status, processingStage, forceNotification, null);
    }

    public NHIOEvent(Long subscriptionID, String hcid, EHXSubscription.NHIOStatus.StatusType status, EHXSubscription.NHIOStatus.ProcessingStageType processingStage, List<String> errors)
    {
        this(subscriptionID, hcid, status, processingStage, false, errors);
    }   
    
    public NHIOEvent(Long subscriptionID, String hcid, EHXSubscription.NHIOStatus.StatusType status, EHXSubscription.NHIOStatus.ProcessingStageType processingStage, boolean forceNotification, List<String> errors)
    {
        this.subscriptionID = subscriptionID;
        this.hcid = hcid;
        this.status = status;
        this.processingStage = processingStage;
        this.forceNotification = forceNotification;
        this.errors = errors;
    }

    public Long getSubscriptionID()
    {
        return subscriptionID;
    }

    public String getHCID()
    {
        return hcid;
    }

    public EHXSubscription.NHIOStatus.ProcessingStageType getProcessingStage()
    {
        return processingStage;
    }

    public boolean getForceNotification()
    {
        return forceNotification;
    }

    public EHXSubscription.NHIOStatus.StatusType getStatus()
    {
        return status;
    }

    public List<String> getErrors()
    {
        return errors;
    }
}
