/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
/**
 *
 * @author david_vetsez
 */
@Entity
@Table(name = "FACILITIES_OPERATIONS")
@XmlRootElement
@NamedQueries({
    @NamedQuery(name = "FacilitiesOperation.findAll", query = "SELECT f FROM FacilitiesOperation f")
    , @NamedQuery(name = "FacilitiesOperation.findByFacilityId", query = "SELECT f FROM FacilitiesOperation f WHERE f.facilityId = :facilityId")
    , @NamedQuery(name = "FacilitiesOperation.findByInAllowPatientDicovery", query = "SELECT f FROM FacilitiesOperation f WHERE f.inAllowPatientDicovery = :inAllowPatientDicovery")
    , @NamedQuery(name = "FacilitiesOperation.findByInAllowDocQuery", query = "SELECT f FROM FacilitiesOperation f WHERE f.inAllowDocQuery = :inAllowDocQuery")
    , @NamedQuery(name = "FacilitiesOperation.findByInAllowDocRetrieve", query = "SELECT f FROM FacilitiesOperation f WHERE f.inAllowDocRetrieve = :inAllowDocRetrieve")
    , @NamedQuery(name = "FacilitiesOperation.findByOutAllowPatientDicovery", query = "SELECT f FROM FacilitiesOperation f WHERE f.outAllowPatientDicovery = :outAllowPatientDicovery")
    , @NamedQuery(name = "FacilitiesOperation.findByOutAllowDocQuery", query = "SELECT f FROM FacilitiesOperation f WHERE f.outAllowDocQuery = :outAllowDocQuery")
    , @NamedQuery(name = "FacilitiesOperation.findByOutAllowDocRetrieve", query = "SELECT f FROM FacilitiesOperation f WHERE f.outAllowDocRetrieve = :outAllowDocRetrieve")
    , @NamedQuery(name = "FacilitiesOperation.findByOnOffBoard", query = "SELECT f FROM FacilitiesOperation f WHERE f.onOffBoard = :onOffBoard")})
@Cacheable(value = true)
public class FacilitiesOperation implements Serializable
{
    private static final long serialVersionUID = 1L;
    // @Max(value=?)  @Min(value=?)//if you know range of your decimal fields consider using these annotations to enforce field validation
    @Id
    @Basic(optional = false)
    @NotNull
    @Column(name = "FACILITY_ID")
    private BigDecimal facilityId;
    @Size(max = 1)
    @Column(name = "IN_ALLOW_PATIENT_DICOVERY")
    private String inAllowPatientDicovery;
    @Size(max = 1)
    @Column(name = "IN_ALLOW_DOC_QUERY")
    private String inAllowDocQuery;
    @Size(max = 1)
    @Column(name = "IN_ALLOW_DOC_RETRIEVE")
    private String inAllowDocRetrieve;
    @Size(max = 1)
    @Column(name = "OUT_ALLOW_PATIENT_DICOVERY")
    private String outAllowPatientDicovery;
    @Size(max = 1)
    @Column(name = "OUT_ALLOW_DOC_QUERY")
    private String outAllowDocQuery;
    @Size(max = 1)
    @Column(name = "OUT_ALLOW_DOC_RETRIEVE")
    private String outAllowDocRetrieve;
    @Size(max = 1)
    @Column(name = "ON_OFF_BOARD")
    private String onOffBoard;
    @JoinColumn(name = "FACILITY_ID", referencedColumnName = "FACILITY_ID", insertable = false, updatable = false)
    @OneToOne(optional = false)
    private Facility facility;

    public FacilitiesOperation()
    {
    }

    public FacilitiesOperation(BigDecimal facilityId)
    {
        this.facilityId = facilityId;
    }

    public BigDecimal getFacilityId()
    {
        return facilityId;
    }

    public void setFacilityId(BigDecimal facilityId)
    {
        this.facilityId = facilityId;
    }

    public String getInAllowPatientDicovery()
    {
        return inAllowPatientDicovery;
    }

    public void setInAllowPatientDicovery(String inAllowPatientDicovery)
    {
        this.inAllowPatientDicovery = inAllowPatientDicovery;
    }

    public String getInAllowDocQuery()
    {
        return inAllowDocQuery;
    }

    public void setInAllowDocQuery(String inAllowDocQuery)
    {
        this.inAllowDocQuery = inAllowDocQuery;
    }

    public String getInAllowDocRetrieve()
    {
        return inAllowDocRetrieve;
    }

    public void setInAllowDocRetrieve(String inAllowDocRetrieve)
    {
        this.inAllowDocRetrieve = inAllowDocRetrieve;
    }

    public String getOutAllowPatientDicovery()
    {
        return outAllowPatientDicovery;
    }

    public void setOutAllowPatientDicovery(String outAllowPatientDicovery)
    {
        this.outAllowPatientDicovery = outAllowPatientDicovery;
    }

    public String getOutAllowDocQuery()
    {
        return outAllowDocQuery;
    }

    public void setOutAllowDocQuery(String outAllowDocQuery)
    {
        this.outAllowDocQuery = outAllowDocQuery;
    }

    public String getOutAllowDocRetrieve()
    {
        return outAllowDocRetrieve;
    }

    public void setOutAllowDocRetrieve(String outAllowDocRetrieve)
    {
        this.outAllowDocRetrieve = outAllowDocRetrieve;
    }

    public String getOnOffBoard()
    {
        return onOffBoard;
    }

    public void setOnOffBoard(String onOffBoard)
    {
        this.onOffBoard = onOffBoard;
    }

    public Facility getFacility()
    {
        return facility;
    }

    public void setFacility(Facility facility)
    {
        this.facility = facility;
    }

    @Override
    public int hashCode()
    {
        int hash = 0;
        hash += (facilityId != null ? facilityId.hashCode() : 0);
        return hash;
    }

		@Override
		public boolean equals( Object obj ) {
			if ( this == obj ) {
				return true;
			}
			if ( obj == null ) {
				return false;
			}
			if ( getClass() != obj.getClass() ) {
				return false;
			}
			final FacilitiesOperation other = (FacilitiesOperation) obj;
			return Objects.equals( this.facilityId, other.facilityId );
		}

    @Override
    public String toString()
    {
        return "gov.va.med.nhin.adapter.ehx.subscription.service.web.entity.FacilitiesOperation[ facilityId=" + facilityId + " ]";
    }
    
}
