/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

/**
 *
 * @author PII
 */
@Entity
@Table(name = "DOCUMENT_REFERENCES")
@XmlRootElement
@NamedQueries({
    @NamedQuery(name = "DocumentReference.findAll", query = "SELECT d FROM DocumentReference d")
    , @NamedQuery(name = "DocumentReference.findByDocumentReferenceId", query = "SELECT d FROM DocumentReference d WHERE d.documentReferenceId = :documentReferenceId")
    , @NamedQuery(name = "DocumentReference.findByResourceId", query = "SELECT d FROM DocumentReference d WHERE d.resourceId = :resourceId")
    , @NamedQuery(name = "DocumentReference.findByPatientId", query = "SELECT d FROM DocumentReference d WHERE d.patientId = :patientId")
    , @NamedQuery(name = "DocumentReference.findByCreatedTime", query = "SELECT d FROM DocumentReference d WHERE d.createdTime = :createdTime")
    , @NamedQuery(name = "DocumentReference.findByLastUpdatedTime", query = "SELECT d FROM DocumentReference d WHERE d.lastUpdatedTime = :lastUpdatedTime")
    , @NamedQuery(name = "DocumentReference.findByPatientIdAndLastUpdatedTime", query = "SELECT d from DocumentReference d WHERE d.patientId = :patientId AND d.lastUpdatedTime >= :lastUpdatedTime")
})
@SequenceGenerator(name = "documentReferenceIdGenerator", sequenceName = "DOCUMENT_REFERENCE_ID_SEQ", allocationSize = 1)
public class DocumentReference implements Serializable
{
    private static final long serialVersionUID = 1L;
    // @Max(value=?)  @Min(value=?)//if you know range of your decimal fields consider using these annotations to enforce field validation
    @Id
    @Basic(optional = false)
    @NotNull
    @Column(name = "DOCUMENT_REFERENCE_ID")
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "documentReferenceIdGenerator")
    private BigDecimal documentReferenceId;
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 36)
    @Column(name = "RESOURCE_ID")
    private String resourceId;
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 17)
    @Column(name = "PATIENT_ID")
    private String patientId;
    @Basic(optional = false)
    @NotNull
    @Column(name = "CREATED_TIME")
    @Temporal(TemporalType.TIMESTAMP)
    private Date createdTime;
    @Basic(optional = false)
    @NotNull
    @Column(name = "LAST_UPDATED_TIME")
    @Temporal(TemporalType.TIMESTAMP)
    private Date lastUpdatedTime;
    @Lob
    @Column(name = "FHIR_RESOURCE")
    private byte[] fhirResource;

    public DocumentReference()
    {
    }

    public DocumentReference(BigDecimal documentReferenceId)
    {
        this.documentReferenceId = documentReferenceId;
    }

    public DocumentReference(BigDecimal documentReferenceId, String resourceId, String patientId, Date createdTime, Date lastUpdatedTime)
    {
        this.documentReferenceId = documentReferenceId;
        this.resourceId = resourceId;
        this.patientId = patientId;
        this.createdTime = createdTime;
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public BigDecimal getDocumentReferenceId()
    {
        return documentReferenceId;
    }

    public void setDocumentReferenceId(BigDecimal documentReferenceId)
    {
        this.documentReferenceId = documentReferenceId;
    }

    public String getResourceId()
    {
        return resourceId;
    }

    public void setResourceId(String resourceId)
    {
        this.resourceId = resourceId;
    }

    public String getPatientId()
    {
        return patientId;
    }

    public void setPatientId(String patientId)
    {
        this.patientId = patientId;
    }

    public Date getCreatedTime()
    {
        return createdTime;
    }

    public void setCreatedTime(Date createdTime)
    {
        this.createdTime = createdTime;
    }

    public Date getLastUpdatedTime()
    {
        return lastUpdatedTime;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime)
    {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public byte[] getFhirResource()
    {
        return fhirResource;
    }

    public void setFhirResource(byte[] fhirResource)
    {
        this.fhirResource = fhirResource;
    }

    @Override
    public int hashCode()
    {
        int hash = 0;
        hash += (documentReferenceId != null ? documentReferenceId.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object)
    {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof DocumentReference)) {
            return false;
        }
        DocumentReference other = (DocumentReference) object;
        if ((this.documentReferenceId == null && other.documentReferenceId != null) || (this.documentReferenceId != null && !this.documentReferenceId.equals(other.documentReferenceId))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString()
    {
        return "gov.va.med.nhin.adapter.subscription.web.dao.DocumentReference[ documentReferenceId=" + documentReferenceId + " ]";
    }

}
