var app = angular.module('subscriptionServiceTesterApp', []);

app.config(function () {

});

app.controller('controller', function ($scope, $interval, $timeout, $filter, $element) {
	
	var mockData ;
	var nhioMax = 20;
	var enableMockErrors = true;
	var mockErrorSeed = 30;
	var wsTimeout = 1000;

	$scope.sites = [
	    {id: "983", name: "983/CHYSHR"},
	    {id: "984", name: "984/DAYTSHR"},
	    {id: "555", name: "555/FunCastle!"}
	]; 
	
	$scope.patients = [
		{id: "1012638924V546709", name: "NWHINONE"} , 
		{id: "1012638925V204624", name: "NWHINTWO"} ,
		{id: "1012664072V817050", name: "NWHINTHREE"} ,
		{id: "1012664114V661390", name: "NWHINFOUR"} ,
		{id: "1012663918V362378", name: "NWHINFIVE"} ,
		{id: "1012581676V377802", name: "CHDRONE"}
	]; 
	$scope.pous = [
		{id: "TREATMENT", type: "Treatment"} , 
		{id: "COVERAGE", type: "Coverage"} 
	]; 
	
	$scope.site = {id:"default",name:"Select Site"};
	$scope.patient = {id:"default",name:"Select Patient"};
	$scope.pou = {id:"default",type:"Select Purpose of Use"};

	$scope.setSite = function(site){
		$scope.site=site;
		$scope.validateStart();
	};	
	$scope.setPatient = function(patient){
		$scope.patient=patient;
		$scope.validateStart();
	};
	$scope.setPou = function(pou){
			$scope.pou=pou;
			$scope.validateStart();
		};

	$scope.subscribe = function(){

		if( $("#subscribeButton").hasClass('disabled')) { 
			return ;
		}

        mockData = undefined;
        
        $scope.documentReferences = null;
        $scope.nhioStatuses = null;
        $scope.subscriptionID = null;
        $scope.subscriptionStatus = null;
        $scope.lastModified = null;
        $scope.ETag = null;

		$scope.announce = $("#isAnnounce").is(":checked");		
		$scope.autoDR = $("#isDocRetrieve").is(":checked");		
		$scope.useWebSocket = $("#isWebSocket").is(":checked");
		$scope.cleanupUI = true;
		
		var req = createInitialSubscription($scope.patient.id,$scope.site.id,$scope.pou.id,$scope.useWebSocket,$scope.announce,$scope.autoDR);

        $scope.subscriptionTime = $filter('date')(new Date(), 'yyyy-MM-ddTHH:mm:ss', 'UTC') + 'Z';
        
        $element.trigger('startSubscriptionEvent'); 
        
        $scope.httpPostSubscriptionMock(req).then(function(response){        	 
            $scope.subscriptionLocation = response.headers['Location'];              
            $scope.monitorSubscriptionMock()
        });     
	}	

	$scope.monitorSubscriptionMock = function () {		
		
		 $scope.httpGetSubscriptionStatusMock($scope.subscriptionLocation).then(function(response){
			 
			 $scope.ETag = response.headers['ETag'];
             $scope.lastModified = response.headers['Last-Modified'];
           
             var subscription = response.data;
             var nhioStatuses = [];
             
             for (var i in subscription.extension) {
                 var ext = subscription.extension[i];
                 if (ext.url === 'http://URL/StructureDefinition/EHXSubscription/nhioStatus') {
                     var nhioStatus = ext.extension;
                     var o = {};
                     for (var j in nhioStatus) {
                         var field = nhioStatus[j];
                         switch (field.url) {
                             case 'hcid':
                                 o.hcid = field.valueString;
                                 break;

                             case 'status':
                                 o.status = field.valueCode;
                                 break;

                             case 'type':
                                 o.stage = field.valueCode;
                                 break;

                             default:
                                 break;
                         }
                     }
                     nhioStatuses.push(o);
                     $element.trigger('updateNhioStatusesEvent', o); 
                 }
             }

             $scope.subscriptionStatus = subscription.status;
             $scope.nhioStatuses = nhioStatuses;
             $scope.subscriptionID = subscription.id;
             
             $element.trigger('updateStatusEvent', 
            		 {"etag":$scope.ETag,"lastMod":$scope.lastModified,
            	 "subStatus":$scope.subscriptionStatus, "subId":$scope.subscriptionID});
            		
             $scope.httpGetDocumentInfoMock('/AdapterSubscriptionService/FHIR/DocumentReference?patient=Patient/' + $scope.patient.id + '&_lastUpdated=>=' + $scope.subscriptionTime).then(function(response){
     			
            	  var bundle = response.data;            	 
                  var documentReferences = [];
                  
                  for (var i in bundle.entry) {
                      var entry = bundle.entry[i].resource;
                      var hcid = "";
                      for (var j in entry.extension) {
                          var ext = entry.extension[j];
                          if (ext.url === "http://URL/StructureDefinition/EHXDocumenteReference/homeCommunityId") {
                              hcid = ext.valueString;
                              break;
                          }
                      }
                      var dr = {hcid:hcid,entry:entry};
                      documentReferences.push(dr);
                      $element.trigger('updateDocRefEvent', dr); 
                  }              
  				  $scope.documentReferences = documentReferences;
             });
             
 			if($scope.subscriptionStatus=="active"){
				$timeout($scope.monitorSubscriptionMock, wsTimeout);
			}else {
				if($scope.cleanupUI){
					$scope.cleanupUI=false;
					$timeout($scope.monitorSubscriptionMock, 100);
				}
			}
		 });

	};
	
	$scope.validateStart = function(){			
		if($scope.site.id != "default" && $scope.patient.id != "default" && $scope.pou.id != "default"){
			$("#subscribeButton").removeClass('disabled');
		}
	};
	
	// ********************* MOCK HTTP ********************	
	$scope.httpPostSubscriptionMock = function(subscription){	
		
		var subId = getRandGUID();
		mockData = {
				"subId" : subId,
				"patId" : $scope.patient.id,
				"subscription":subscription,
				"extData" : []
		};
		updateSubscriptionAfterPostResponse(subscription, subId);    
		var response = {         		
				"headers":createSubscriptionResponseHeader(subId),
				"data":subscription
		};
		return new Promise(function(resolve, reject) {
			resolve(response);
		});
     };
 	$scope.httpGetSubscriptionStatusMock = function(subscriptionLocation){		

		var subscription = mockData.subscription ;
		
		if(subscription["status"]=="requested"){
			subscription["status"]="active";
		}
		
		var isPd = $scope.announce;
		var isDr = $scope.autoDR;	
		
		var subId = mockData.subId;		
		var subCriteria = subscription.criteria;
		var pid = subCriteria.substring(subCriteria.lastIndexOf('/')+1);
	
		var urlStatus = 'http://URL/StructureDefinition/EHXSubscription/nhioStatus';
		
		if(subscription["status"]!="off"){
			
			var nhioExtCnt = countSubNhioStatusExt(subscription);
			if(nhioExtCnt < nhioMax){
				
				var batchCnt = getRandInt(3)+1;
				batchCnt = nhioExtCnt + batchCnt > nhioMax ? nhioMax - nhioExtCnt : batchCnt;
				
				for(var i=0;i<batchCnt;i++){			
					var newHcid = getRandHCID();
					var nhioStatusExt = createNhioStatusExtension(newHcid, "NEW", "STARTING");	
					addNhioStatusToSubscription(subscription, nhioStatusExt);				
					mockData.extData.push({"hcid":newHcid});
				}			
				nhioExtCnt = countSubNhioStatusExt(subscription);			
			} 
			
			var extAry = getSubNhioStatusExtAry(subscription);
			for(n in extAry){
			
				var status = getNhioStatusExtStatus(extAry[n]);
				var type = getNhioStatusExtType(extAry[n]);			
				var hcid = getNhioStatusExtHcid(extAry[n]);
				
				if(status=="DONE"){		
					var extDataObj = getExtDataObjByHcid(hcid);
					if(extDataObj.docRefAry == undefined){
						var docRefCnt = coinFlip()=="heads"?1:2;
						extDataObj.docRefAry = createDocRefAry(docRefCnt, hcid, subId, pid);
					}				
				} else {						
					if(coinFlip()=="heads"){
						incrementNhioStatusExtType(extAry[n],isPd,isDr,enableMockErrors);					
					}
				}
			}
		}
        var response = {         		
        		"headers":createSubscriptionResponseHeader(subId),
        		"data":subscription
        };		
        return new Promise(function(resolve, reject) {
        	resolve(response);
        });
	}
	$scope.httpGetDocumentInfoMock = function(docRefUrl){		
		
		var subscription = mockData.subscription ;
		var pid = docRefUrl.substring( docRefUrl.lastIndexOf('/')+1, docRefUrl.lastIndexOf("&"));
		
		var allDocRefAry = [] ; 	
		
		var extAry = getSubNhioStatusExtAry(subscription);
		var processingComplete = true;
		for(n in extAry){

			var status = getNhioStatusExtStatus(extAry[n]);
			var type = getNhioStatusExtType(extAry[n]);
			
			var hcid = getNhioStatusExtHcid(extAry[n]);
			var extDataObj = getExtDataObjByHcid(hcid);
			
			if(status=="DONE"&& extDataObj.docRefAry !== undefined){
				var docRefAry = extDataObj.docRefAry;
				for(var x = 0 ; x<docRefAry.length; x++){
					allDocRefAry.push(docRefAry[x]);
				}
			}else{
				processingComplete = false;
			}
		}
		if(processingComplete){
			subscription["status"]="off";
			$scope.subscriptionStatus = "off";
		}
		
		var response = {
			"data":createMockResourceBundle(pid,allDocRefAry)
		} ; 		
        return new Promise(function(resolve, reject) {
        	resolve(response);
        });
	};	
	 
	//TODO: clean up each loops, return false to break
	// ********************* MOCK UTILS / HELPERS ********************	
	function getExtDataObjByHcid(hcid){
		var ret = null;
		$.each(mockData.extData, function(i, v) {
			if (v.hcid == hcid) {
				ret = v;
			}
		});				
		$.Deferred();
		return ret == undefined ? null : ret;		
	}
	function getSubNhioStatusExtAry(subscription){		
		var ary = [];	
		$.each(subscription.extension, function(i, v) {
			if (v.url == 'http://URL/StructureDefinition/EHXSubscription/nhioStatus') {
				ary.push(v.extension);
			}
		});				
		$.Deferred();
		return ary;
	}
	function countSubNhioStatusExt(subscription){
		var nhioStatusCnt = 0 ; 
		$.each(subscription.extension, function(i, v) {
			if (v.url == 'http://URL/StructureDefinition/EHXSubscription/nhioStatus') {
				nhioStatusCnt++;
			}
		});		
		$.Deferred();
		return nhioStatusCnt;		
	}
	function getNhioStatusExtType(nhioStatusExt){		
		return getNhioStatusExt(nhioStatusExt,"type","valueCode");
	}
	function getNhioStatusExtStatus(nhioStatusExt){		
		return getNhioStatusExt(nhioStatusExt,"status","valueCode");
	}
	function getNhioStatusExtHcid(nhioStatusExt){		
		return getNhioStatusExt(nhioStatusExt,"hcid","valueString");
	}
	function getNhioStatusExt(nhioStatusExt,url,field){	
		var ret ;
		$.each(nhioStatusExt, function(x, y) {
			if (y.url == url) {	        	        	
				ret = y[field];
			}
		});
		$.Deferred();
		return ret;
	}

	function updateNhioStatusExtType(nhioStatusExt,val){		
		updateNhioStatusExt(nhioStatusExt,"type","valueCode",val)
	}
	function updateNhioStatusExtStatus(nhioStatusExt,val){		
		updateNhioStatusExt(nhioStatusExt,"status","valueCode",val)
	}
	function updateNhioStatusExt(nhioStatusExt,url,field,val){	
		$.each(nhioStatusExt, function(x, y) {
			if (y.url == url) {	        	        	
				y[field]=val;
			}
		});
		$.Deferred();
	}

	function incrementNhioStatusExtType(nhioStatusExt,isPd,isDr,enableErrors){
		
		if(getNhioStatusExtStatus(nhioStatusExt)=="DONE"){
			return ;
		}

		var isError = false;
		if(enableErrors){
			if(getRandInt(mockErrorSeed)+1==1){
				isError = true;
			}
		}
		
		var type = getNhioStatusExtType(nhioStatusExt);

		if(isPd){			
			switch(type){				
			case "STARTING":			
				updateNhioStatusExtType(nhioStatusExt,"ANNOUNCE");
				updateNhioStatusExtStatus(nhioStatusExt,"PROCESSING");					
				return ;
			case "ANNOUNCE":				
				if(isError){
					updateNhioStatusExtType(nhioStatusExt,"ANNOUNCE_FAILURE");
				}else{
					updateNhioStatusExtType(nhioStatusExt,"ANNOUNCE_SUCCESS");
				}
				return ;
			case "ANNOUNCE_FAILURE":
				updateNhioStatusExtStatus(nhioStatusExt,"DONE");
				return ;
			};
		}
		switch(type){			
		case "STARTING":
		case "ANNOUNCE_SUCCESS":
			updateNhioStatusExtType(nhioStatusExt,"DOCUMENT_QUERY");
			updateNhioStatusExtStatus(nhioStatusExt,"PROCESSING");
			return ;
		case "DOCUMENT_QUERY":	
			if(isError){
				updateNhioStatusExtType(nhioStatusExt,"DOCUMENT_QUERY_FAILURE");
			}else{
				updateNhioStatusExtType(nhioStatusExt,"DOCUMENT_QUERY_SUCCESS");
				if(!isDr){
					updateNhioStatusExtStatus(nhioStatusExt,"DONE");
				}
			}
			return ;
		case "DOCUMENT_QUERY_FAILURE":
			updateNhioStatusExtStatus(nhioStatusExt,"DONE");
			return ;
		};			
		if(isDr){			
			switch(type){				
			case "DOCUMENT_QUERY_SUCCESS":	
				updateNhioStatusExtType(nhioStatusExt,"DOCUMENT_RETRIEVE");
				return ;
			case "DOCUMENT_RETRIEVE":
				if(isError){
					updateNhioStatusExtType(nhioStatusExt,"DOCUMENT_RETRIEVE_FAILURE");
				}else{
					updateNhioStatusExtType(nhioStatusExt,"DOCUMENT_RETRIEVE_SUCCESS");
				}
				return ;
			case "DOCUMENT_RETRIEVE_SUCCESS":
			case "DOCUMENT_RETRIEVE_FAILURE":
				updateNhioStatusExtStatus(nhioStatusExt,"DONE");
				return ;
			};
		} 
	}
	function incrementNhioStatusExtTypeX(nhioStatusExt,isPd,isDr,enableError){

		var type = getNhioStatusExtType(nhioStatusExt);

		if(isPd){			
			switch(type){				
			case "STARTING":			
				updateNhioStatusExtType(nhioStatusExt,"ANNOUNCE");
				updateNhioStatusExtStatus(nhioStatusExt,"PROCESSING");					
				return ;
			case "ANNOUNCE":	
				updateNhioStatusExtType(nhioStatusExt,"ANNOUNCE_SUCCESS");
				return ;
			case "ANNOUNCE_FAILURE":
				updateNhioStatusExtStatus(nhioStatusExt,"DONE");
				return ;
			};
		}
		switch(type){			
		case "STARTING":
		case "ANNOUNCE_SUCCESS":
			updateNhioStatusExtType(nhioStatusExt,"DOCUMENT_QUERY");
			updateNhioStatusExtStatus(nhioStatusExt,"PROCESSING");
			return ;
		case "DOCUMENT_QUERY":	
			updateNhioStatusExtType(nhioStatusExt,"DOCUMENT_QUERY_SUCCESS");
			if(!isDr){
				updateNhioStatusExtStatus(nhioStatusExt,"DONE");
			}
			return ;
		case "DOCUMENT_QUERY_FAILURE":
			updateNhioStatusExtStatus(nhioStatusExt,"DONE");
			return ;
		};			
		if(isDr){			
			switch(type){				
			case "DOCUMENT_QUERY_SUCCESS":	
				updateNhioStatusExtType(nhioStatusExt,"DOCUMENT_RETRIEVE");
				return ;
			case "DOCUMENT_RETRIEVE":
				updateNhioStatusExtType(nhioStatusExt,"DOCUMENT_RETRIEVE_SUCCESS");
				updateNhioStatusExtStatus(nhioStatusExt,"DONE");
				return ;
			case "DOCUMENT_RETRIEVE_FAILURE":
				updateNhioStatusExtStatus(nhioStatusExt,"DONE");
				return ;
			};
		} 
	}

	function updateSubscriptionAfterPostResponse(subscription, subId){
		delete subscription.channel["endpoint"];
		delete subscription.channel["header"];
		delete subscription.channel["payload"];
		delete subscription["contact"];
		delete subscription["end"];
		subscription["id"] = subId;
		subscription["meta"] = createMetadata("http://URL/StructureDefinition/EHXSubscription");
	}	
	function addNhioStatusToSubscription(subscription, nhioStatus){		
		subscription.extension.push(nhioStatus);
	}

	// ********************* MOCK SETUP ********************	
	function createMockResourceBundle(pid,docRefAry){
		var timestamp = getTimestamp();
		var lastUpdatedEnc = encodeURIComponent(timestamp);
		var pidEnc = encodeURIComponent("/"+pid);		
		var bundleData = {				
				"entry":docRefAry,
				"id": getRandGUID(),
				"link": [
					{
						"relation": "self",
						"url": "http://localhost:7001/AdapterSubscriptionService/FHIR/DocumentReference?_lastUpdated=" + lastUpdatedEnc + "&patient=Patient" + pidEnc
					}
					],
					"meta": {
						"lastUpdated": timestamp
					},
					"resourceType": "Bundle",
					"total": docRefAry.length,
					"type": "searchset"
		} ; 
		return bundleData;		
	}
	function createDocRefAry(drCnt, xHcid, subId, patId){		
		var code = "34133-9";
		var display = "Summarization Of Episode" ;
		var sysId = "urn:oid:1.3.6.1.4.1.19376.1.2.3";
		var docRefAry = [ ];

		for(var i=0;i<drCnt;i++){	
			var docRefId = getRandGUID();
			var docUniqueId = getRandGUID();
			var docRef = createDocumentReferenceEntry(xHcid, subId, patId, docRefId, docUniqueId, sysId, code, display, getTimestamp());
			docRefAry.push(docRef);
		}
		return docRefAry;
	}	
	function createInitialSubscription(pid,siteId,pouID,useWs,isAnnounce,isAutoDR){

		var req = {							
				resourceType: "Subscription",
				// from Resource: id, meta, implicitRules, and language
				// from DomainResource: text, contained, extension, and modifierExtension
				status: "requested", // R!  requested | active | error | off
				contact: [], // Contact details for source (e.g. troubleshooting)
				end: null, // When to automatically delete the subscription
				reason: "Prefetch", // R!  Description of why this subscription was created
				criteria: "DocumentReference?patient=Patient/" + pid, // R!  Rule for server push criteria
				error: "<string>", // Latest error note
				channel: {// R!  The channel on which to report matches to the criteria
					type: useWs ? "websocket" : "rest-hook", // R!  rest-hook | websocket | email | sms | message
							endpoint: !useWs ? "http://MOCK-HOST:8090/on-notify" : null, // Where the channel points to
									payload: null, // Mimetype to send, or omit for no payload
									header: !useWs ? ["X-TransactionID: DAS-0987654321"] : null // Usage depends on the channel type
				},
				extension: [{
					url: "http://URL/StructureDefinition/EHXSubscription/announcePatient",
					valueBoolean: isAnnounce
				}, {
					url: "http://URL/StructureDefinition/EHXSubscription/autoDocRetrieve",
					valueBoolean: isAutoDR
				}, {
					url: "http://URL/StructureDefinition/EHXSubscription/assertions",
					extension: [{
						url: "userID",
						valueString: siteId + ":user123"
					}, {
						url: "userName",
						valueString: "User 1-2-3"
					}, {
						url: "systemID",
						valueString: "JLV"
					}, {
						url: "organizationID",
						valueString: "2.16.840.1.113883.4.349.983"
					}, {
						url: "organizationName",
						valueString: "Department of Veterans Affairs - CHYSHR"
					}, {
						url: "purposeOfUse",
						valueString: pouID
					}, {
						url: "role",
						valueString: "112247003"
					}]
				}]
		};		
		return req;
	}	
	function createNhioStatusExtension(hcid, status, stage){
		var nhioStatus = {
				"extension": [
					{
						"url": "hcid",
						"valueString": hcid
					},
					{
						"url": "status",
						"valueCode": status
					},
					{
						"url": "type",
						"valueCode": stage
					}
					],
					"url": "http://URL/StructureDefinition/EHXSubscription/nhioStatus"
		} ; 
		return nhioStatus;
	}	
	function createDocumentReferenceEntry(hcid, subscriptionId, patientId, docRefId, docUniqueId, systemId, codingCls, codingDisplay, lastUpdated){

		var mockCoding = [{
			"code": codingCls,
			"display": codingDisplay,
			"system": "http://loinc.org"
		}];    
		var mockContent = [{
			"attachment": {
				"contentType": "text/xml",
				"hash": getRandomHash(),
				"language": "en-US",
				"size": getRandomFileSize(),
				"url": "Binary/" + docRefId
			},
			"format": {
				"code": "urn:ihe:pcc:xphr:2007",
				"display": "HL7 CCD Document",
				"system": systemId
			}
		} ];
		var mockExt = [
			{
				"url": "http://URL/StructureDefinition/EHXDocumenteReference/homeCommunityId",
				"valueString": hcid
			},
			{
				"url": "http://URL/StructureDefinition/EHXDocumenteReference/repositoryUniqueId",
				"valueString": hcid.substring(hcid.indexOf("oid:")+4)
			},
			{
				"url": "http://URL/StructureDefinition/EHXDocumenteReference/documentUniqueId",
				"valueString": docUniqueId
			},
			{
				"url": "http://URL/StructureDefinition/EHXDocumenteReference/subscription",
				"valueReference": {
					"reference": "Subscription/" + subscriptionId
				}
			}
			];
		var mockMasterID = {"value": docUniqueId} ; 
		var mockSub = { "reference": "Patient/" + patientId} ;
		var mockRsc = { "class": { "coding" : mockCoding},
				"content": mockContent,
				"created": "2017-01-01T20:31:36-04:00",
				"description": "Summarization Of Episode",
				"extension": mockExt,
				"id": docRefId,
				"masterIdentifier": mockMasterID,
				"meta": createMetadata("http://URL/StructureDefinition/EHXDocumentReference"),
				"resourceType": "DocumentReference",
				"subject":mockSub,
				"type": { "coding" : mockCoding}
		} ;
		var mockEntry = { 
				"fullUrl": "http://localhost:7001/AdapterSubscriptionService/FHIR/DocumentReference/" + docRefId,
				"resource" : mockRsc
		} ; 
		return mockEntry ; 
	}	
	function createMetadata(url){		
		var mockMeta = {
				"lastUpdated": getTimestamp(),
				"profile": [
					url
					],
					"versionId": "0"
		} ; 
		return mockMeta;		
	}	
	function createSubscriptionResponseHeader(subId){
		var header = {
				'ETag':'W/"0"',
				"Last-Modified":getTimestamp(),
				"Location":"http://localhost:7001/AdapterSubscriptionService/FHIR/Subscription"+subId,
				'If-None-Match':'W/"149"'
		};
		return header;    	 
	}

	// *************** UTILS / HELPERS ***************
	function getTimestamp(){
		return new Date().toISOString();
	}
	function getRandAryElement(ary){
		var randomIdx = Math.floor(Math.random() * ary.length);
		return ary[randomIdx];
	}		
	function getRandomFileSize(){		
		return Math.floor(Math.random() * 5000)+5000;
	}	
	function getRandSysID(){
		var r = Math.floor((1 + Math.random()) * 0x10000)
		.toString(16)
		.substring(0,5);				        	
		return "urn:oid:1.3.6.1.4.1." + r + ".1.2.3";
	}	
	function getRandHCID(){
		var r = Math.floor((1 + Math.random()) * 0x10000)
		.toString(16)
		.substring(0,5);				        	
		return "urn:oid:2.16.840.1.11." + r + ".17.8.1";
	}
	function getRandGUID() {
		function s4() {
			return Math.floor((1 + Math.random()) * 0x10000)
			.toString(16)
			.substring(1);
		}
		return s4() + s4() + '-' + s4() + '-' + s4() + '-' +
		s4() + '-' + s4() + s4() + s4();
	}
	function getRandomHash() {
		var text = "";
		var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

		for (var i = 0; i < 54; i++)
			text += possible.charAt(Math.floor(Math.random() * possible.length));

		return text+"==";
	}
	function coinFlip(){		
		return getRandInt(2)==0?"heads":"tails";
	}
	function getRandInt(max){
		return Math.floor(Math.random() * Math.floor(max));
	}

	function printj(data){
		console.log(JSON.stringify(data,null,"\t"));
	}
});





