
	$(document).ready(function() {	
		$(document).on('startSubscriptionEvent', function(event, data) {
			//subscriptionStart();
		});
		$(document).on('updateStatusEvent', function(event, data) {
			//updateUIStatus(data);	
		});
		$(document).on('updateNhioStatusesEvent', function(event, data) {
			//updateNhioStatusTable(data);
		});
		$(document).on('updateDocRefEvent', function(event, data) {
			//updateDocRefTable(data);
		});
	});

	function subscriptionStart(){
		$("#divStatus").css("padding-left","5%");
	}
	
	function updateNhioStatusTable(data){		
		
		if(data==undefined)
			return ;
		
		var html = createStatusTableRow(data.hcid,data.stage,data.status,data.errors);
		if($('#tableStatus > tbody > tr').length == 0 ) { 		
			$('#tableStatus > tbody:last-child').append(html);
			return;
		}
		
		var hcidIdx = findRowIdxOfColVal("tableStatus",0,data.hcid);
		if(hcidIdx == -1){			
			$('#tableStatus > tbody:last-child').append(html);	
			sortTable("tableStatus",0);			
		} else {			
			$('#tableStatus > tbody > tr:nth-child(' + hcidIdx + ')').replaceWith(html);
		}
	}
	
	function updateDocRefTable(docRef){		
		
		if(docRef==undefined)
			return;
	
		var docRefIdx = findRowIdxOfColVal("tableDocRef",1,docRef.entry.masterIdentifier.value);
		if(docRefIdx != -1){
			return ;
		}		
		
		var html = createDocRefTableRow(docRef.hcid,docRef.entry);
		if($('#tableDocRef > tbody > tr').length == 0 ) { 		
			$('#tableDocRef > tbody:last-child').append(html);
			return;
		}		
		$('#tableDocRef > tbody:last-child').append(html);	
		sortTable("tableDocRef",0);
	}
	
	function sortTable(tableId, colIdx){

		var table = $('#' + tableId + "> tbody");
		var rows = $('tr', table);

		rows.sort(function(a, b) {        
			var ka = $(a).find('td').eq(colIdx).text();
			var kb = $(b).find('td').eq(colIdx).text();
			return (ka > kb) ? 1 : (ka < kb) ? -1 : 0;
		}); 
		rows.each(function(index, row) {
			table.append(row);
		});
	}

	function strcmp(strA,strB){
		//return strA < strB ? -1 : strA > strB ? 1 : 0;
		return strA.localeCompare(strB);
	}
	
	function findRowIdxOfColVal(tableId,colIdx,val){	
		 var idx = -1;
		 $("#" + tableId +" tr").each(function(index) {
           $row = $(this);           
           var colVal = $row.find('td').eq(colIdx).text();
           if (colVal == val) {	
	    		idx = index;
	    		return false;
           }
		    });
		 return idx;
	}
	
	function createStatusTableRow(hcid,type,status, errors){		
		
		var progress = status == "NEW" ? 0 : status == "PROCESSING" ? 50 : 100;
		//console.log(progress);
		//This was a failure. Not using it. Maybe come back and try some other time.
		var cssOpacity = "class='progress-bar' role='progressbar' aria-valuenow='" + progress + "' " + 
						"aria-valuemin='0' aria-valuemax='150' style='width:150px;color:black;background-color:#f2f2f2'";
		
		var color = "";

		if(type.indexOf("SUCCESS")>-1){			
			color =  "#d4efdf";
		} else if(type.indexOf("FAILURE")>-1){
			 color = "#ffcccc";
		} else { 
			color = "#fff5cc";
		}
		
		var newRow = "<tr>" + 
					"<td style=''>" + hcid + "</td>" + 
					"<td style='background-color:" + color + "' >" + type + "</td>" + 
					"<td >" + status + "</td>" + 
					"</tr>" ;
		
		return newRow;
	}
	
	function createDocRefTableRow(hcid,entry){
	
		var newRow = "<tr>" + 
					"<td>" + hcid + "</td>" + 
					"<td>" + entry.masterIdentifier.value + "</td>" + 
					"<td  >" + entry.class.coding[0].code + "</td>" + 
					"<td><a target='docWindow' href='/AdapterSubscriptionService/FHIR/" + entry.content[0].attachment.url + "'>" + entry.description + "</a></td>";
					"</tr>" ;
		return newRow;	
	}
	
	function updateUIStatus(data){		
       var etag = data.etag;
       var lastMod = data.lastMod;
       var status = data.subStatus;
       var subId = data.subId;

		$("#divStatus").removeClass("text-center");
		$("#divStatus").removeClass("text-left");

		$("#labelVers").text("Version: " + etag);
		$("#labelLastMod").text("Last Modified: " + lastMod);
		$("#labelStatus").text("Status: " + status);
		$("#labelSubId").text("SubID: " + subId);
	}
		
	//Used for testing
	function printj(data){
		console.log(JSON.stringify(data,null,"\t"));
	}
	
				
				