var app = angular.module('subscriptionServiceTesterApp', []);

app.config(function () {

});

app.controller('controller',  function ($scope, $http, $timeout, $filter, $element) {
		
		$scope.sites = [
		    {id: "983", name: "983/CHYSHR"},
		    {id: "984", name: "984/DAYTSHR"}
		]; 
		$scope.patients = [
			{id: "1012638924V546709", name: "NWHINONE"} , 
            {id: "1012638925V204624", name: "NWHINTWO"} ,
			{id: "1012664072V817050", name: "NWHINTHREE"} ,
			{id: "1012664114V661390", name: "NWHINFOUR"} ,
            {id: "1012663918V362378", name: "NWHINFIVE"} ,
            {id: "1012581676V377802", name: "CHDRONE"}
        ]; 
        $scope.pous = [
			{id: "TREATMENT", type: "Treatment"} , 
			{id: "COVERAGE", type: "Coverage"} 
		];
        
        $scope.protocols = [
            "http",
            "https"
        ];
		
		$scope.site = {id:"default",name:"Select Site"};
        $scope.patient = {id:"default",name:"Select Patient"};
        $scope.pou = {id:"default",type:"Select Purpose of Use"};
        
        $scope.notifyUrlProtocol = "http";
        $scope.notifyHostName = "MOCK-HOST";
        $scope.notifyPort = "PORT";
        $scope.notifyPath = "on-notify";
		
		$scope.setSite = function(site){
			$scope.site=site;
			$scope.validateStart();
		};	
		$scope.setPatient = function(patient){
			$scope.patient=patient;
			$scope.validateStart();
        };
        $scope.setPou = function(pou){
			$scope.pou=pou;
			$scope.validateStart();
		};
        $scope.setProtocol = function(proto) {
            $scope.notifyUrlProtocol = proto;
            $scope.validateStart();
        }
		
		$scope.validateStart = function(){			
			if($scope.site.id != "default" && $scope.patient.id != "default" && $scope.pou.id != "default"){
				$("#subscribeButton").removeClass('disabled');
			}
		};
		
		$scope.subscribe = function () {
			
			if( $("#subscribeButton").hasClass('disabled')) { 
				return ;
			}
			
            $scope.documentReferences = [];
            $scope.nhioStatuses = [];
            $scope.subscriptionID = null;
            $scope.subscriptionStatus = null;
            $scope.lastModified = null;
            $scope.ETag = null;
            var req = {
                resourceType: "Subscription",
                // from Resource: id, meta, implicitRules, and language
                // from DomainResource: text, contained, extension, and modifierExtension
                status: "requested", // R!  requested | active | error | off
                contact: [], // Contact details for source (e.g. troubleshooting)
                end: null, // When to automatically delete the subscription
                reason: "Prefetch", // R!  Description of why this subscription was created
                criteria: "DocumentReference?patient=Patient/" + $scope.patient.id, // R!  Rule for server push criteria
                error: "<string>", // Latest error note
                channel: {// R!  The channel on which to report matches to the criteria
                    type: $scope.useWebSocket ? "websocket" : "rest-hook", // R!  rest-hook | websocket | email | sms | message
                    endpoint: !$scope.useWebSocket ? $scope.notifyUrlProtocol+"://"+$scope.notifyHostName+":"+$scope.notifyPort+"/"+$scope.notifyPath : null, // Where the channel points to
                    payload: null, // Mimetype to send, or omit for no payload
                    header: !$scope.useWebSocket ? ["X-TransactionID: DAS-0987654321"] : null // Usage depends on the channel type
                },
                extension: [{
                        url: "http://URL/StructureDefinition/EHXSubscription/announcePatient",
                        valueBoolean: $scope.announce
                    }, {
                        url: "http://URL/StructureDefinition/EHXSubscription/autoDocRetrieve",
                        valueBoolean: $scope.autoDR
                    }, {
                        url: "http://URL/StructureDefinition/EHXSubscription/assertions",
                        extension: [{
                                url: "userID",
                                valueString: $scope.site.id + ":user123"
                            }, {
                                url: "userName",
                                valueString: "User 1-2-3"
                            }, {
                                url: "systemID",
                                valueString: "JLV"
                            }, {
                                url: "organizationID",
                                valueString: "2.16.840.1.113883.4.349.983"
                            }, {
                                url: "organizationName",
                                valueString: "Department of Veterans Affairs - CHYSHR"
                            }, {
                                url: "purposeOfUse",
                                valueString: $scope.pou.id
                            }, {
                                url: "role",
                                valueString: "112247003"
                            }]
                    }]
            };

            $scope.subscriptionTime = $filter('date')(new Date(), 'yyyy-MM-ddTHH:mm:ss', 'UTC') + 'Z';

            //$element.trigger('startSubscriptionEvent'); 
            
            $http.post('/AdapterSubscriptionService/FHIR/Subscription', JSON.stringify(req)).then(function (response) {
                $scope.subscriptionLocation = response.headers('Location').replace(/^http[s]?:/i, '');

                if ($scope.useWebSocket) {
                    $scope.setupWebSocket();
                }

                $scope.monitorSubscription();
            });
        };
        $scope.getSubscriptionStatusClass = function() {
            
        };
        $scope.getNhioStatusClass = function(nhioStatus) {
            if(typeof nhioStatus.stage == "string" && nhioStatus.stage.indexOf("SUCCESS") > -1) {
                return "success";
            }
            if(typeof nhioStatus.stage == "string" && nhioStatus.stage.indexOf("FAILURE") > -1) {
                return "danger";
            }
            return "info";
        };
        $scope.findNHIOStatus = function (hcid) {
            for(var i in $scope.nhioStatuses) {
                if(typeof hcid == "string" && hcid == $scope.nhioStatuses[i].hcid) {
                    return $scope.nhioStatuses[i];
                }
            }
            var o = {errors:"Errors:",documentReferences:[],hcid:hcid};
            $scope.nhioStatuses.push(o);
            return o;
        };
        $scope.findDocRefFromHCID = function(hcid, entry) {
            var o = $scope.findNHIOStatus(hcid);
            for(var i in o.documentReferences) {
                if(
                    typeof o.documentReferences[i].entry == "object" 
                    && typeof o.documentReferences[i].entry.id == "string" 
                    && typeof entry == "object" 
                    && typeof entry.id == "string" 
                    && o.documentReferences[i].entry.id == entry.id
                ) {
                    return o.documentReferences[i];
                }
            }
            var d = {};
            o.documentReferences.push(d);
            return d;
        };
        $scope.monitorSubscription = function () {
            var config = null;
            if ($scope.ETag !== null) {
                config = {headers: {'If-None-Match': $scope.ETag}};
            }
            $http.get($scope.subscriptionLocation, config).then(function (response) {
                $scope.ETag = response.headers('ETag');
                $scope.lastModified = response.headers('Last-Modified');
                var subscription = response.data;
                var nhioStatuses = [];
                for (var i in subscription.extension) {
                    var ext = subscription.extension[i];
                    if (ext.url === 'http://URL/StructureDefinition/EHXSubscription/nhioStatus') {
                        var nhioStatus = ext.extension;
                        var o = {errors:"Errors:"};
                        for (var j in nhioStatus) {
                            var field = nhioStatus[j];
                            switch (field.url) {
                                case 'hcid':
                                    o.hcid = field.valueString.replace("urn:oid:", "");
                                    break;

                                case 'status':
                                    o.status = field.valueCode;
                                    break;

                                case 'type':
                                    o.stage = field.valueCode;
                                    break;
                                
                                case 'error':
                                    o.errors += ('\n' + field.valueString);
                                    break;
                                    
                                default:
                                    break;
                            }
                        }
                        var n = $scope.findNHIOStatus(o.hcid);
                        n.className = $scope.getNhioStatusClass(o);
                        n.hcid = o.hcid;
                        n.status = o.status;
                        n.stage = o.stage;
                        n.errors = o.errors;
                        // add more stuff here if necessary (like line classes)
                        //nhioStatuses.push(o);
                    }
                }
                $scope.subscriptionStatus = subscription.status;
                //$scope.nhioStatuses = nhioStatuses;
                $scope.subscriptionID = subscription.id;
                $scope.subStatusClass = $scope.getSubscriptionStatusClass();
                
                //$element.trigger('updateStatusEvent', 
               	//	 {"etag":$scope.ETag,"lastMod":$scope.lastModified,
               	// "subStatus":$scope.subscriptionStatus, "subId":$scope.subscriptionID});
                
                $scope.refreshDocuments();

                if (!$scope.useWebSocket) {
                    if (subscription.status !== 'off' && subscription.status !== 'error') {
                        $timeout($scope.monitorSubscription, 500);
                    }
                } else {
                    if (subscription.status === 'off' || subscription.status === 'error') {
        				if($scope.cleanupUI){
        					$scope.cleanupUI=false;
        					//TODO: remove or not? $timeout($scope.monitorSubscriptionMock, 500);
        				}
                        $scope.tearDownWebSocket();
                    }
                }
            }, function (response) {
                if (!$scope.useWebSocket) {
                    if (response.status === 304) {
                        $timeout($scope.monitorSubscription, 500);
                    }
                } else {
                    if (response.status !== 304) {
        				if($scope.cleanupUI){
        					$scope.cleanupUI=false;
        					//TODO: remove or not? $timeout($scope.monitorSubscriptionMock, 500);
        				}
                        $scope.tearDownWebSocket();
                    }
                }
            });
        };
        $scope.docsRefreshing = false;
        $scope.refreshDocuments = function () {
            if($scope.docsRefreshing) { console.log("We're already pulling documents, let's just wait for those..."); return; }
            $scope.docsRefreshing = true;
            $http.get('/AdapterSubscriptionService/FHIR/DocumentReference?patient=Patient/' + $scope.patient.id + '&_lastUpdated=>=' + $scope.subscriptionTime).then(function (response) {
                var bundle = response.data;
                var documentReferences = [];
                for (var i in bundle.entry) {
                    var entry = bundle.entry[i].resource;
                    var hcid = "";
                    var documentRetrieved = false;
                    for (var j in entry.extension) {
                        var ext = entry.extension[j];
                        if (ext.url === "http://URL/StructureDefinition/EHXDocumenteReference/homeCommunityId") {
                            hcid = ext.valueString.replace("urn:oid:", "");
                        }
                        else if (ext.url === "http://URL/StructureDefinition/EHXDocumenteReference/documentRetrieved") {
                            documentRetrieved = ext.valueBoolean;
                        }
                    }
                    var o = $scope.findDocRefFromHCID(hcid, entry);
                    o.hcid = hcid;
                    o.entry = entry;
                    o.documentRetrieved = documentRetrieved;
                    documentReferences.push(o);
                    $scope.pullDocument(o, entry.content[0].attachment.url);
                }
                $scope.documentReferences = documentReferences;
                $scope.docsRefreshing = false;
            });
        };
        $scope.pullDocument = function(documentObject, url) {
            if($scope.autoDownload && typeof documentObject.pulledDocument !== "object") {
                $http.get("/AdapterSubscriptionService/FHIR/"+url).then(function(res) { 
                    documentObject.pulledDocument = res;
                    console.log(res); 
                    $scope.refreshDocuments();
                });
            }
        };
        $scope.setupWebSocket = function () {
            var prot = window.location.protocol === 'https:' ? 'wss' : 'ws';
            var ws = $scope.ws = new WebSocket(prot + '://' + window.location.hostname + ':' + window.location.port + '/AdapterSubscriptionService/SubscriptionWS');

            ws.onopen = function () {
                ws.send('bind ' + $scope.subscriptionLocation.substr($scope.subscriptionLocation.lastIndexOf('/') + 1));
            };

            ws.onerror = function () {
                console.log('An error happened');
            };

            ws.onmessage = function (message) {
                console.log(message.data);
                var data = "" + message.data;
                if (data.indexOf('ping') === 0) {
                    ws.send('pong ' + $scope.subscriptionLocation.substr($scope.subscriptionLocation.lastIndexOf('/') + 1));
                    $scope.monitorSubscription();
                }
                else if (data.indexOf('unbound') === 0) {
                    ws.close();
                }
            };

            ws.onclose = function () {
                console.log('WebSocket closed');
                if ($scope.subscriptionStatus !== 'off') {
                    $scope.monitorSubscription();
                    console.log('  Re-connecting.');
                    $timeout($scope.setupWebSocket, 500);
                }
            };
        };
        
        $scope.tearDownWebSocket = function() {
            $scope.ws.send('unbind ' + $scope.subscriptionLocation.substr($scope.subscriptionLocation.lastIndexOf('/') + 1));
        };
        
        $scope.alert = function(msg) {
            alert(msg);
        };
    });