/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.logging.messaging;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import gov.va.med.nhin.adapter.logging.LogConstants;
import gov.va.med.nhin.adapter.logging.messaging.fhir.FHIREventAuditingFactory;
import java.io.StringWriter;
import org.hl7.fhir.dstu3.model.AuditEvent;
import static org.junit.Assert.assertEquals;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.MDC;

/**
 *
 * @author ryan
 */
public class FHIREventAuditingFactoryTest {

	private StringWriter writer = new StringWriter();
	private final FHIREventAuditingFactory fac = new FHIREventAuditingFactory() {
		private final FhirContext ctx = FhirContext.forDstu3();
		private final IParser parser = ctx.newJsonParser();

		@Override
		public void info( AuditEvent event ) {
			event.setRecorded( null );
			// System.out.println( parser.encodeResourceToString( event ) );
			writer.append( parser.encodeResourceToString( event ) );
		}
	};

	public FHIREventAuditingFactoryTest() {
	}

	@Before
	public void setUp() {
		writer = new StringWriter();
	}

	@Test
	public void testOne() {
		AuditEvent ae = fac.newEvent( LogConstants.AuditingEvent.PDIN_BEGIN, getClass() );
		fac.info( ae );
		String expected = "{\"resourceType\":\"AuditEvent\",\"type\":{\"system\":\"http://dicom.nema.org/resources/ontology/DCM\",\"code\":\"110112\",\"display\":\"Query\"},\"subtype\":[{\"system\":\"urn:gov:va:med:nhin:adapter:audit\",\"code\":\"PD_IN-Request\",\"display\":\"Cross Gateway Patient Discovery - Request\"}],\"action\":\"E\",\"source\":{\"site\":\"gov.va.med.nhin.adapter.logging.messaging.FHIREventAuditingFactoryTest\"}}";
		assertEquals( expected, writer.toString() );
	}

	@Test
	public void testWithTxn() {
		MDC.put( LogConstants.CORRELATION_MDCKEY, "my transaction id" );
		AuditEvent ae = fac.newEvent( LogConstants.AuditingEvent.PDIN_BEGIN, getClass() );
		MDC.clear();
		fac.info( ae );

		String expected = "{\"resourceType\":\"AuditEvent\",\"type\":{\"system\":\"http://dicom.nema.org/resources/ontology/DCM\",\"code\":\"110112\",\"display\":\"Query\"},\"subtype\":[{\"system\":\"urn:gov:va:med:nhin:adapter:audit\",\"code\":\"PD_IN-Request\",\"display\":\"Cross Gateway Patient Discovery - Request\"}],\"action\":\"E\",\"source\":{\"site\":\"gov.va.med.nhin.adapter.logging.messaging.FHIREventAuditingFactoryTest\"},\"entity\":[{\"identifier\":{\"type\":{\"coding\":[{\"system\":\"http://connectopensource.org/transaction\",\"code\":\"txn\",\"display\":\"Correlation ID\"}]},\"value\":\"my transaction id\"},\"type\":{\"system\":\"http://hl7.org/fhir/audit-entity-type\",\"code\":\"2\",\"display\":\"System Object\"},\"role\":{\"system\":\"http://hl7.org/fhir/object-role\",\"code\":\"20\",\"display\":\"Job\"}}]}";
		assertEquals( expected, writer.toString() );
	}
}
