/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.translators.PruningFilterDataTranslator;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.datamanager.SmartHashMap;
import gov.va.med.nhin.adapter.datamanager.config.ReferenceType;
import gov.va.med.nhin.adapter.utils.config.PropertiesType;
import gov.va.med.nhin.adapter.utils.config.PropertyType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author ryan
 */
public class PruningFilterDataTranslatorTest {

	public PruningFilterDataTranslatorTest() {
	}

	@BeforeClass
	public static void setUpClass() {
	}

	@AfterClass
	public static void tearDownClass() {
	}

	@Before
	public void setUp() {
	}

	@After
	public void tearDown() {
	}

	private Reference getRefType() {
		ReferenceType rt = new ReferenceType();
		PropertyType pp1 = new PropertyType();
		pp1.setName( "listName" );
		pp1.setValue( "A1" );

		PropertyType pp2 = new PropertyType();
		pp2.setName( "subListName" );
		pp2.setValue( "docs" );

		PropertyType pp3 = new PropertyType();
		pp3.setName( "key" );
		pp3.setValue( "id" );

		PropertyType pp4 = new PropertyType();
		pp4.setName( "pruneListNames" );
		pp4.setValue( "one,two" );

		PropertyType pp5 = new PropertyType();
		pp5.setName( "pruneKey" );
		pp5.setValue( "id" );

		PropertiesType pt = new PropertiesType();
		pt.getProperty().add( pp1 );
		pt.getProperty().add( pp2 );
		pt.getProperty().add( pp3 );
		pt.getProperty().add( pp4 );
		pt.getProperty().add( pp5 );
		rt.setProperties( pt );

		return new Reference( rt, null, null );
	}

	@Test
	public void testTranslateOk() throws Exception {

		SmartHashMap topsmh = new SmartHashMap();
		SmartHashMap encounters = new SmartHashMap();
		topsmh.put( "A1", Arrays.asList( encounters ) );

		List<SmartHashMap> docs = new ArrayList<>();
		encounters.put( "docs", docs );

		for ( int i = 0; i < 5; i++ ) {
			SmartHashMap doc = new SmartHashMap();
			doc.put( "id", i );
			docs.add( doc );
		}

		SmartHashMap aOne = new SmartHashMap();
		aOne.put( "id", "1" );
		SmartHashMap aTwo = new SmartHashMap();
		aTwo.put( "id", "6" );

		SmartHashMap bOne = new SmartHashMap();
		bOne.put( "id", "2" );
		SmartHashMap bTwo = new SmartHashMap();
		bTwo.put( "id", "f" );

		List<SmartHashMap> aList = new ArrayList<>();
		aList.add( aOne );
		aList.add( aTwo );
		topsmh.put( "one", aList );

		List<SmartHashMap> bList = new ArrayList<>();
		bList.add( bOne );
		bList.add( bTwo );
		topsmh.put( "two", bList );

		PruningFilterDataTranslator filter = new PruningFilterDataTranslator();
		List<SmartHashMap> input = Arrays.asList( topsmh );
		Object obj = filter.translate( input, null,
				getRefType(), null );

		assertEquals( obj, input );
		assertEquals( 1, List.class.cast( topsmh.get( "one" ) ).size() );
		assertEquals( 1, List.class.cast( topsmh.get( "two" ) ).size() );
		assertEquals( 5, docs.size() );
	}

	@Test
	public void testTranslateNoDocs() throws Exception {

		SmartHashMap topsmh = new SmartHashMap();
		SmartHashMap encounters = new SmartHashMap();
		topsmh.put( "A1", Arrays.asList( encounters ) );

		SmartHashMap aOne = new SmartHashMap();
		aOne.put( "id", "1" );
		SmartHashMap aTwo = new SmartHashMap();
		aTwo.put( "id", "6" );

		SmartHashMap bOne = new SmartHashMap();
		bOne.put( "id", "2" );
		SmartHashMap bTwo = new SmartHashMap();
		bTwo.put( "id", "f" );

		List<SmartHashMap> aList = new ArrayList<>();
		aList.add( aOne );
		aList.add( aTwo );
		topsmh.put( "one", aList );

		List<SmartHashMap> bList = new ArrayList<>();
		bList.add( bOne );
		bList.add( bTwo );
		topsmh.put( "two", bList );

		PruningFilterDataTranslator filter = new PruningFilterDataTranslator();
		List<SmartHashMap> input = Arrays.asList( topsmh );
		Object obj = filter.translate( input, null,
				getRefType(), null );

		assertEquals( obj, input );
		assertEquals( 2, List.class.cast( topsmh.get( "one" ) ).size() );
		assertEquals( 2, List.class.cast( topsmh.get( "two" ) ).size() );
	}
}
