/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.datamanager;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

/**
 *
 * @author ryan
 */
public class FileBasedVistA implements DataAdapter<String> {

	private static final Logger log = Logger.getLogger( FileBasedVistA.class );
	private static final File RESOURCES = new File( "src/test/resources" );

	@Override
	public List<String> getData( DataQuery dataQuery ) throws Exception {
		List<String> list = new ArrayList<>();

		Set<String> notesDocs = new HashSet<>( Arrays.asList(
				"11488-4",
				"VistA.findConsultNotes3",
				"VistA.findHistoryAndPhysicalNotes",
				"34133-9-C" ) );

		if ( notesDocs.contains( dataQuery.getName() ) ) {
			String result = readFile( "VistA.notesDocuments", ".xml" );
			list.add( result );
		}
		else if ( dataQuery.getName().startsWith( "MPI." ) ) {
			String result = readFile( dataQuery.getName(), ".txt" );
			list.add( result );
		}
		else if ( dataQuery.getName().startsWith( "VistA." ) ) {
			String result = readFile( dataQuery.getName(), ".xml" );
			list.add( result );
		}

		return list;

	}

	private static String readFile( String fname, String extension ) throws IOException {
		return FileUtils.readFileToString( new File( RESOURCES, fname + extension ), "utf-8" );
	}
}
