package gov.va.med.nhin.adapter.xmlutils;

import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author David Vazquez
 */
public class XMLTemplateFactory
{
	static private Map<String, XMLTemplate> xmlTemplates = new HashMap<String, XMLTemplate>();

	static public synchronized XMLTemplate getXMLTemplate(String configFilename) throws XMLUtilsException
	{
		XMLTemplate ret = xmlTemplates.get(configFilename);
		if(ret == null)
		{
			ret = new XMLTemplate(configFilename);
			xmlTemplates.put(configFilename, ret);
		}

		return ret;
	}
}
