/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.utils.soap.handler;

import gov.va.med.nhin.adapter.logging.EventAuditingFactory;
import gov.va.med.nhin.adapter.logging.EventAuditingFactoryImpl;
import gov.va.med.nhin.adapter.utils.NullChecker;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.xml.XMLConstants;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.hl7.fhir.dstu3.model.AuditEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author david_vetsez
 */
public class LoggingSOAPHandler implements SOAPHandler<SOAPMessageContext>
{
    private static final Logger logger = LoggerFactory.getLogger(LoggingSOAPHandler.class);
    private static final String[] MESSAGE_HEADERS = {
        "INBOUND REQUEST",
        "OUTBOUND RESPONSE",
        "INBOUND RESPONSE",
        "OUTBOUND REQUEST"
    };

    private final boolean isClient;

    public LoggingSOAPHandler()
    {
        this(false);
    }

    public LoggingSOAPHandler(boolean isClient)
    {
        this.isClient = isClient;
    }

    @Override
    public Set<QName> getHeaders()
    {
        return null;
    }

    @Override
    public void close(MessageContext context)
    {
    }

    @Override
    public boolean handleFault(SOAPMessageContext context)
    {
        return true;
    }

    @Override
    public boolean handleMessage(SOAPMessageContext smc)
    {
        Boolean isOutbound = (Boolean)smc.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);
        String messageHeader = MESSAGE_HEADERS[(isOutbound ? 1 : 0) + (isClient ? 2 : 0)];

        SOAPMessage message = smc.getMessage();
        String endpointAddress = null;
        for (String prop : Arrays.asList("javax.xml.ws.service.endpoint.address",
            "com.sun.xml.ws.transport.http.servlet.requestURL")) {
            Object o = smc.get(prop);
            if (NullChecker.isNotNullOrEmpty(o)) {
                endpointAddress = String.class.cast(o);
                break;
            }
        }

        if (!isOutbound) {
            // log a bunch of stuff
            EventAuditingFactory<AuditEvent> fac = EventAuditingFactoryImpl.getFactory(AuditEvent.class);
            fac.info(fac.newEvent(smc, getClass()));
        }

        if (logger.isTraceEnabled()) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Source source = new DOMSource(message.getSOAPPart());
                TransformerFactory transFact = TransformerFactory.newInstance();
                transFact.setFeature(XMLConstants.FEATURE_SECURE_PROCESSING, true);
                transFact.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD"/*XMLConstants.ACCESS_EXTERNAL_DTD*/, "");
                transFact.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet"/*XMLConstants.ACCESS_EXTERNAL_STYLESHEET*/, "");
                Transformer transformer = transFact.newTransformer();
                transformer.transform(source, new StreamResult(baos));
                
                logger.trace("SOAP {} MESSAGE\nEndpoint Address: {}\nPayload: {}", messageHeader, endpointAddress, new String(baos.toByteArray()));
            }
            catch (Throwable e) {
                logger.debug("Error occurred writing message to log.  Proceeding anyway.", e);
            }
        }
        else if (logger.isDebugEnabled()) {
            logger.debug("SOAP {} MESSAGE endpoint: {}", messageHeader, endpointAddress);
        }

        return true;
    }
}
