package gov.va.med.nhin.adapter.utils.prefetch;

import gov.va.med.nhin.adapter.prefetch.PrefetchQueryResponse;
import gov.va.med.nhin.adapter.prefetch.RetrieveDocumentsResponse;
import gov.va.med.nhin.adapter.utils.JAXBContextFactory;
import gov.va.med.nhin.adapter.utils.NullChecker;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponseType.DocumentResponse;

import java.io.File;
import java.util.Properties;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

import oasis.names.tc.ebxml_regrep.xsd.rim._3.ExtrinsicObjectType;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.ClientProperties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefetchHelper
{
	private static final Logger logger = LoggerFactory.getLogger(PrefetchHelper.class.getName());

	public static PrefetchQueryResponse queryDocuments(Properties props, String patientICN, String loinc)
	{
		PrefetchQueryResponse responseData = null;
		try
		{
			String serviceUrl = props.getProperty("prefetch.service.url");
			int connectTimeout = NullChecker.isNotNullOrEmpty(props.getProperty("prefetch.connect.timeout")) ? Integer.parseInt(props.getProperty("prefetch.connect.timeout")) : 0;
			int readTimeout = NullChecker.isNotNullOrEmpty(props.getProperty("prefetch.read.timeout")) ? Integer.parseInt(props.getProperty("prefetch.read.timeout")) : 0;

			logger.debug("serviceUrl: {}, connectTimeout: {}, readTimeout: {}", new Object[] { serviceUrl, connectTimeout, readTimeout });

			Client client = null;
			if(connectTimeout > 0 || readTimeout > 0)
			{
				ClientConfig configuration = new ClientConfig();
				if(connectTimeout > 0)
				{
					configuration.property(ClientProperties.CONNECT_TIMEOUT, connectTimeout * 1000);
				}
				if(readTimeout > 0)
				{
					configuration.property(ClientProperties.READ_TIMEOUT, readTimeout * 1000);
				}
				client = ClientBuilder.newClient(configuration);

			}
			else
			{
				client = ClientBuilder.newClient();
			}

			WebTarget target;
			if(NullChecker.isNotNullOrEmpty(loinc))
			{
				target = client.target(serviceUrl).queryParam("icn", patientICN).queryParam("loinc", loinc);
			}
			else
			{
				target = client.target(serviceUrl).queryParam("icn", patientICN);
			}

			Response response = target.request(MediaType.APPLICATION_XML).get();
			
			response.bufferEntity();
			String noDataTest = response.readEntity(String.class);
			logger.debug("response: {}", noDataTest);
			if(StringUtils.isNotBlank(noDataTest) && StringUtils.equalsIgnoreCase(noDataTest, "No Data Found")) {
				return null;
			}

			responseData = response.readEntity(PrefetchQueryResponse.class);
		}
		catch(Throwable ex)
		{
			logger.error("Error while making a call to prefetch system. Please correct this.", ex);
		}

		return responseData;
	}

	public static PrefetchQueryResponse queryDocumentsTest(Properties props, String patientICN, String loinc)
	{

		PrefetchQueryResponse responseData = null;
		try
		{
			String serviceUrl = props.getProperty("prefetch.service.url");
			int connectTimeout = NullChecker.isNotNullOrEmpty(props.getProperty("prefetch.connect.timeout")) ? Integer.parseInt(props.getProperty("prefetch.connect.timeout")) : 0;
			int readTimeout = NullChecker.isNotNullOrEmpty(props.getProperty("prefetch.read.timeout")) ? Integer.parseInt(props.getProperty("prefetch.read.timeout")) : 0;

			logger.debug("serviceUrl: {}, connectTimeout: {}, readTimeout: {}", new Object[] { serviceUrl, connectTimeout, readTimeout });

			Client client = null;
			if(connectTimeout > 0 || readTimeout > 0)
			{
				ClientConfig configuration = new ClientConfig();
				if(connectTimeout > 0)
				{
					configuration.property(ClientProperties.CONNECT_TIMEOUT, connectTimeout * 1000);
				}
				if(readTimeout > 0)
				{
					configuration.property(ClientProperties.READ_TIMEOUT, readTimeout * 1000);
				}
				client = ClientBuilder.newClient(configuration);

			}
			else
			{
				client = ClientBuilder.newClient();
			}

			WebTarget target;
			if(NullChecker.isNotNullOrEmpty(loinc))
			{
				target = client.target(serviceUrl).queryParam("icn", patientICN).queryParam("loinc", loinc);
			}
			else {
				target = client.target(serviceUrl).queryParam("icn", patientICN);
			}

			Response response = target.request(MediaType.APPLICATION_XML).get();
			System.out.println("response: " + response.toString());
			responseData = response.readEntity(PrefetchQueryResponse.class);
		}
		catch(Throwable ex)
		{
			logger.error("Error while making a call to prefetch system. Please correct this.", ex);
		}
		return responseData;
	}

	public static RetrieveDocumentsResponse retrieveDocuments(final Properties props, final String adapterDocId, final String exchangeDocId, final String repositoryId) throws Exception
	{
		RetrieveDocumentsResponse responseData = null;
		try
		{
			String serviceUrl = props.getProperty("prefetch.service.url");
			int connectTimeout = NullChecker.isNotNullOrEmpty(props.getProperty("prefetch.connect.timeout")) ? Integer.parseInt(props.getProperty("prefetch.connect.timeout")) : 0;
			int readTimeout = NullChecker.isNotNullOrEmpty(props.getProperty("prefetch.read.timeout")) ? Integer.parseInt(props.getProperty("prefetch.read.timeout")) : 0;

			logger.debug("serviceUrl: {}, connectTimeout: {}, readTimeout: {}", new Object[] { serviceUrl, connectTimeout, readTimeout });

			Client client = null;
			if(connectTimeout > 0 || readTimeout > 0)
			{
				ClientConfig configuration = new ClientConfig();
				if(connectTimeout > 0)
				{
					configuration.property(ClientProperties.CONNECT_TIMEOUT, connectTimeout * 1000);
				}
				if(readTimeout > 0)
				{
					configuration.property(ClientProperties.READ_TIMEOUT, readTimeout * 1000);
				}
				client = ClientBuilder.newClient(configuration);

			}
			else
			{
				client = ClientBuilder.newClient();
			}
			WebTarget target = client.target(serviceUrl).queryParam("docId", adapterDocId).queryParam("repositoryId", repositoryId);

			logger.debug("Prefetch Retrieve Request URI: {}", target.getUri().toString());

			Response response = target.request(MediaType.APPLICATION_XML).get();
			response.bufferEntity();
			logger.debug("response: {} ", response.readEntity(String.class));
			responseData = response.readEntity(RetrieveDocumentsResponse.class);

			// Need to change docid from the adapter generated one to the exchange id.
			if(responseData != null)
			{
				if(CollectionUtils.isNotEmpty(responseData.getDocumentResponse()))
				{
					for(DocumentResponse document : responseData.getDocumentResponse())
					{
						document.setDocumentUniqueId(exchangeDocId);
					}
				}
			}
		}
		catch(Throwable ex)
		{
			logger.error("Error while making a call to prefetch system. Please correct this.", ex);
		}

		return responseData;
	}

	public static void main(String[] args) throws Exception
	{
		System.out.println("start");

		{
			PrefetchQueryResponse pqR = new PrefetchQueryResponse();
			ExtrinsicObjectType test = new ExtrinsicObjectType();
			test.setId("test");
			oasis.names.tc.ebxml_regrep.xsd.rim._3.ObjectFactory objFactory = new oasis.names.tc.ebxml_regrep.xsd.rim._3.ObjectFactory();
			;
			pqR.getIdentifiable().add(objFactory.createExtrinsicObject(test));
			ExtrinsicObjectType test1 = new ExtrinsicObjectType();
			test1.setId("test1");
			// oasis.names.tc.ebxml_regrep.xsd.rim._3.ObjectFactory objFactory =
			// new oasis.names.tc.ebxml_regrep.xsd.rim._3.ObjectFactory();
			;
			pqR.getIdentifiable().add(objFactory.createExtrinsicObject(test1));
			JAXBContext context = JAXBContextFactory.getInstance().getJaxBContext(PrefetchQueryResponse.class);
			Marshaller m = context.createMarshaller();
			m.marshal(pqR, new File("c:/temp/pqr.txt"));

			System.out.println("pqr done");
			// if (true) {
			// return;
			// }
		}

		Properties props = new Properties();
		// props.setProperty("prefetch.service.url",
		// "http://URL:PORT/PrefetchServices/services/prefetchService/queryDocuments");
		props.setProperty("prefetch.service.url", "http://prefetch.fiscientific.org/queryDocuments?format=soap");

		// props.setProperty("prefetch.service.path", "retrieveDocument");

		// System.out.println("retrievingDocument");
		// RetrieveDocumentsResponse resp = retrieveDocumentsNew(props,
		// "testDocId", "testReposId");
		// JAXBContext context =
		// JAXBContextFactory.getInstance().getJaxBContext(RetrieveDocumentsResponse.class);
		// Marshaller m = context.createMarshaller();
		// m.marshal(resp, new File("c:/temp/test1.txt"));
		System.out.println("queryDocument");
		props.setProperty("prefetch.service.path", "queryDocuments");
		PrefetchQueryResponse pqResponse = queryDocumentsTest(props, "1012581676V377802", null);

		System.out.println("done");

	}
	// public static RetrieveDocumentsResponse retrieveDocuments(Properties
	// props,
	// RetrieveDocumentsRequest rdRequest) throws Exception {
	// String serviceUrl = props.getProperty("prefetch.service.url");
	// String path = props.getProperty("prefetch.service.path");
	// //String user = props.getProperty("timer.management.service.user");
	// //String password =
	// EncryptDecryptUtil.decryptString(props.getProperty("timer.management.service.password"));
	//
	// logger.fine("serviceUrl: " + serviceUrl);
	// logger.fine("path: " + path);
	//// logger.fine("user: " + user);
	//
	// Client c = ClientBuilder.newClient();
	// //Client c = Client.create();
	// WebTarget target = c.target(serviceUrl).path(path);
	//
	// Response response
	// = target.request(MediaType.APPLICATION_XML)
	// .post(Entity.entity(rdRequest, MediaType.APPLICATION_XML));
	// logger.fine("response: " + response.toString());
	// RetrieveDocumentsResponse retString =
	// response.readEntity(RetrieveDocumentsResponse.class);
	// return retString;
	// }

	// public static AdhocQueryResponse queryDocuments(Properties props,
	// AdhocQueryRequest queryRequest) throws Exception {
	// String serviceUrl = props.getProperty("prefetch.service.url");
	// String path = props.getProperty("prefetch.service.path");
	//
	// logger.fine("serviceUrl: " + serviceUrl);
	// logger.fine("path: " + path);
	//
	// Client c = ClientBuilder.newClient();
	// //Client c = Client.create();
	// WebTarget target = c.target(serviceUrl).path(path);
	//
	// Response response
	// = target.request(MediaType.APPLICATION_XML)
	// .post(Entity.entity(queryRequest, MediaType.APPLICATION_XML));
	// logger.fine("response: " + response.toString());
	// AdhocQueryResponse retString =
	// response.readEntity(AdhocQueryResponse.class);
	// return retString;
	// }
}