/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.med.nhin.adapter.utils.encoders;

/**
 *
 * @author David Vazquez
 */
public class DCLLPEncoder
{
    static public final String CR = "\r";
    static public final String CRLF = "\r\n";
    static public final String DATA_BEGIN = "DATA PARAM=MPI" + CRLF;
    static public final String DATA_END = "\u001B\u001B\u001B";
    static public final int PREFIX_LENGTH = 3;

    static public String encode(String message)
    {
        String[] parts = message.split(CR);
        for (int i = 0;  i < parts.length;  ++i) {
            String part = parts[i];
            int len = part.length();
            String prefix = String.valueOf(len);
            while (prefix.length() < PREFIX_LENGTH) {
                prefix = "0" + prefix;
            }
            parts[i] = prefix + part;
        }

        StringBuffer ret = new StringBuffer();
        ret.append(DATA_BEGIN);
        for (String part : parts) {
            ret.append(part);
        }
        ret.append("003").append(DATA_END);

        return ret.toString();
    }

    static public String decode(String message)
    {
        StringBuffer ret = new StringBuffer();
        int index = message.indexOf(DATA_BEGIN);
        if (index != -1) {
            index += DATA_BEGIN.length();
            while (index < message.length()) {
                int count = Integer.parseInt(message.substring(index, index+PREFIX_LENGTH));
                if (count > 0) {
                    String s = message.substring(index+PREFIX_LENGTH, index+PREFIX_LENGTH+count);
                    if (!s.equals(DATA_END)) {
                        ret.append(s);
                    }
                }
                else if (ret.charAt(ret.length() - 1) != CR.charAt(0)) {
                    ret.append(CR);
                }

                index += PREFIX_LENGTH + count;
            }
        }

        return ret.toString();
    }
}
