package gov.va.med.nhin.adapter.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import org.apache.commons.io.FilenameUtils;

/**
 *
 * @author David Vazquez
 */
public class Utils
{
	static public boolean isCollection(Object obj)
	{
		return obj != null && (obj instanceof Collection || obj.getClass().isArray());
	}

	static public int getCollectionLength(Object obj)
	{
		int ret = 0;

		if(obj != null)
		{
			if(obj instanceof Collection)
			{
				ret = ((Collection) obj).size();
			}
			else if(obj.getClass().isArray())
			{
				ret = Array.getLength(obj);
			}
		}

		return ret;
	}

	static public URL getResource(String path) throws MalformedURLException
	{
		URL ret = null;
		path = FilenameUtils.normalize(path); /*normalizes the file path to mitigate the Path manipulation/hacking vulnerability */
                File f = new File(path);

		if(f.exists())
		{
			ret = new URL("file:" + path);
		}
		else
		{
			if(path.startsWith("file:"))
			{
				path = path.substring(5);
			}
			ret = Thread.currentThread().getContextClassLoader().getResource(path);
		}

		return ret;
	}

	static public InputStream getResourceAsStream(String path) throws FileNotFoundException
	{
		path = FilenameUtils.normalize(path);/*normalizes the file path to mitigate the Path manipulation/hacking vulnerability */
		InputStream ret = null;
		File f = new File(path);

		if(f.exists())
		{
			ret = new FileInputStream(f);
		}
		else
		{
			if(path.startsWith("file:"))
			{
				path = path.substring(5);
			}
			ret = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
		}

		return ret;
	}
}
