package gov.va.med.nhin.adapter.mvi.hl7transforms;

import gov.hhs.fha.nhinc.transform.subdisc.HL7ArrayTransforms;
import gov.hhs.fha.nhinc.transform.subdisc.HL7DataTransformHelper;
import gov.hhs.fha.nhinc.transform.subdisc.HL7PatientTransforms;
import gov.va.med.nhin.adapter.utils.NullChecker;
import javax.xml.bind.JAXBElement;
import org.hl7.v3.AD;
import org.hl7.v3.ADExplicit;
import org.hl7.v3.ENExplicit;
import org.hl7.v3.ObjectFactory;
import org.hl7.v3.PNExplicit;
import org.hl7.v3.PRPAMT201301UV02BirthPlace;
import org.hl7.v3.PRPAMT201301UV02Patient;
import org.hl7.v3.PRPAMT201301UV02Person;
import org.hl7.v3.PRPAMT201306UV02LivingSubjectBirthPlaceAddress;
import org.hl7.v3.PRPAMT201306UV02LivingSubjectName;
import org.hl7.v3.PRPAMT201306UV02ParameterList;

/**
 *
 * @author PII
 */
public class AdapterHL7PatientTransforms extends HL7PatientTransforms
{
	public static org.hl7.v3.PRPAMT201301UV02Patient create201301Patient(PRPAMT201306UV02ParameterList paramList, String aaId)
	{
		PRPAMT201301UV02Patient patient = HL7PatientTransforms.create201301Patient(paramList, aaId);

		/**
		 * HL7PatientTransforms does not add/set the use code to differentiate
		 * the types of persons (e.g. patient versus mothers maiden name).
		 * Therefore we need to re-do the Subject Names to add the use code.
		 */
		PRPAMT201301UV02Person person = patient.getPatientPerson().getValue();
		person.getName().clear();

		if(paramList.getLivingSubjectName() != null && paramList.getLivingSubjectName().size() > 0)
		{
			for(PRPAMT201306UV02LivingSubjectName subjName : paramList.getLivingSubjectName())
			{

				for(ENExplicit name : subjName.getValue())
				{
					PNExplicit newName = HL7DataTransformHelper.convertENtoPN(name);
					newName = HL7ArrayTransforms.copyNullFlavors(name, newName);

					if(NullChecker.isNotNullOrEmpty(name.getUse()) && name.getUse().get(0) != null)
					{
						newName.getUse().add(name.getUse().get(0));
					}
					else
					{
						// default it to Legal Name of Patient.
						newName.getUse().add("L");
					}
					person.getName().add(newName);
				}
			}
		}

		// Set the Birth Place Address
		ObjectFactory of = new ObjectFactory();
		if(paramList.getLivingSubjectBirthPlaceAddress() != null && paramList.getLivingSubjectBirthPlaceAddress().size() > 0)
		{
			for(PRPAMT201306UV02LivingSubjectBirthPlaceAddress pobAddr : paramList.getLivingSubjectBirthPlaceAddress())
			{
				for(ADExplicit newAdd : pobAddr.getValue())
				{
					PRPAMT201301UV02BirthPlace bp = of.createPRPAMT201301UV02BirthPlace();
					AD ad = new AD();
					ad.getContent().addAll(newAdd.getContent());
					bp.setAddr(ad);

					javax.xml.namespace.QName xmlqname = new javax.xml.namespace.QName("urn:hl7-org:v3", "birthPlace");
					JAXBElement<PRPAMT201301UV02BirthPlace> element = new JAXBElement<PRPAMT201301UV02BirthPlace>(xmlqname, PRPAMT201301UV02BirthPlace.class, bp);
					person.setBirthPlace(element);
				}
			}
		}

		return patient;
	}
}
