/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.logging;

import gov.va.med.nhin.adapter.datamanager.DataQuery;

/**
 * A class to simplify and standardize certain messaging-specific events
 *
 * @param <T> the type of audit class to use
 */
public interface MessagingHelper<T> {

  static final String PARTNER = "partner";
  static final String REQUEST = "request";
  static final String PATIENT = "patientId";
  static final String LOCALPATIENT = "localPatientId";
  static final String REMOTEPATIENT = "remotePatientId";
  static final String FACILITY = "facility";

  public static enum QueryType { REQUEST, RESPONSE };

  /**
   * Gets a partner authorization event
   *
   * @param evt the type of partner authorization
   * @param source who's doing the logging
   * @param partner the partner in question
   * @return the event to be logged
   */
  public T partnerauth(LogConstants.AuditingEvent evt, Class<?> source,
          String partner);

  /**
   * Gets a request/response event.
   *
   * @param evt the type of request/response
   * @param source who's doing the logging
   * @param partner the partner doing the work
   * @return the event to be logged
   */
  public T reqres(LogConstants.AuditingEvent evt, Class<?> source,
          String partner);

  /**
   * Adds a "Patient ID" entity to the given event
   *
   * @param event the event to modify
   * @param pid the partner doing the work
   * @return the event sent as the first arg
   */
  public T addPatientId(T event, String pid);

  /**
   * Adds a "Patient ID" entity to the given event
   *
   * @param event the event to modify
   * @param local local patient id
   * @param remote remote patient id
   * @return the event sent as the first arg
   */
  public T addLocalRemotePatientIds(T event, String local, String remote);

  /**
   * Adds a "Patient ID" entity to the given event
   *
   * @param event the event to modify
   * @param facility the facility to add as an agent
   * @return the event sent as the first arg
   */
  public T addAgentFacility(T event, String facility);

  /**
   * Adds a new Entity that represents a Query object
   *
   * @param ae The event to modify
   * @param obj the thing we're going to encode as the query
   * @param objClass the class of obj
   * @param t type of logging to do
   * @param entityid an internal id used for locating the newly-added entity. This
   * is useful for locating the entity later via
   * {@link #addDetail(java.lang.Object, java.lang.String, java.lang.String, java.lang.String) }.
   * If null or empty, the entity cannot be referenced later (but is still added here)
   * @return the event
   */
  public T addQuery(T ae, Object obj, Class<?> objClass, QueryType t, String entityid);

  /**
   * A convenience function that adds a new Entity that represents a DataQuery 
   * object, and adds all named parameters as details. It is not possible to
   * retrieve the added elements with this function call.
   *
   * @param ae The event to modify
   * @param obj the data query we're going to encode as the query
   * @param t type of logging to do
   * @return the event
   */
  public T addQuery(T ae, DataQuery obj, QueryType t);
  /**
   *
   * @param ae the event to modify
   * @param type the type of detail to add
   * @param value the value of detail to add
   * @param entityid the entityid passed to
   * {@link #addQuery(java.lang.Object, java.lang.Object, gov.va.med.nhin.adapter.logging.MessagingHelper.QueryType, java.lang.String) }.
   * If null or not found, this function does nothing
   * @return the event
   */
  public T addDetail(T ae, String entityid, String type, String value);
}
