/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.logging;

import gov.va.med.nhin.adapter.logging.LogConstants.AuditingEvent;
import org.slf4j.MDC;

/**
 * A container for a ThreadLocal object. This class is designed to be like
 * {@link MDC} for objects needed for logging. This class should be used as a
 * last-ditched effort at accurate logging. Generally, if you can avoid using it
 * by refactoring functions and whatnot, do that instead. This class is probably
 * most useful in situations where you cannot easily change an existing API, but
 * you do have access to implementation classes.
 *
 * @author ryan
 */
public class EventAuditingThreadData {

	public static AuditingEvent getEventAndClear() {
		String val = MDC.get( "event" );
		if ( null == val ) {
			return AuditingEvent.INFO;
		}

		AuditingEvent ae = AuditingEvent.valueOf( val );
		MDC.remove( "event" );
		return ae;
	}

	public static void setEvent( AuditingEvent ae ) {
		MDC.put( "event", ae.toString() );
	}
}
