/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.logging;

import gov.va.med.nhin.adapter.logging.messaging.fhir.FHIREventAuditingFactory;
import org.hl7.fhir.dstu3.model.AuditEvent;

/**
 * @author ryan
 */
public abstract class EventAuditingFactoryImpl {

	public static <T> EventAuditingFactory<T> getFactory( Class<T> k ) {
		if ( AuditEvent.class.equals( k ) ) {
			return (EventAuditingFactory<T>) new FHIREventAuditingFactory();
		}
		throw new IllegalArgumentException( "No factory for class type: "
				+ k.getCanonicalName() );
	}
}
