package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.xmlutils.XMLTemplate;
import gov.va.med.nhin.adapter.xmlutils.XMLTemplateFactory;
import org.w3c.dom.Document;

/**
 *
 * @author David Vazquez
 */
public class XMLTemplateDataTranslator implements DataTranslator<Document>
{
	@Override
	public Document translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		Document ret = null;

		if(input != null)
		{
			String configFilename = translation.getProperty("configFilename");

			XMLTemplate xmlTemplate = XMLTemplateFactory.getXMLTemplate(configFilename);
			ret = xmlTemplate.fillIn(input);
		}

		return ret;
	}
}
