/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;
import java.io.IOException;
import org.apache.commons.lang3.StringEscapeUtils;

/**
 *
 * @author PII
 */
public class XMLFragmentDataTranslator implements DataTranslator
{
    static public final String DEFAULT_NAMESPACE = "urn:hl7-org:v3";
    @Override
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery) throws IOException
    {
        String ret;
        String enclosingElementName = translation.getProperty("enclosingElementName");
        String convertLineFeedsToElement = translation.getProperty("convertLineFeedsToElement");
        String defaultNamespace = translation.getProperty("defaultNamespace");
        if(NullChecker.isNullOrEmpty(defaultNamespace)) { defaultNamespace = DEFAULT_NAMESPACE; }
        String[] workingSet;
        
        if (!(input instanceof String)) {
            throw new DataManagerException("input must be of type java.lang.String.");
        }
        
        if (NullChecker.isNotNullOrEmpty(convertLineFeedsToElement)) {
            workingSet = ((String)input).split("(\\n|\\r|\\r\\n)");
        }
        else {
            workingSet = new String[]{(String)input};
        }
        
        StringBuilder resultString = new StringBuilder();
        for (int i = 0;  i < workingSet.length;  ++i) {
            if (i > 0) {
                resultString.append(convertLineFeedsToElement);
            }
            resultString.append(StringEscapeUtils.escapeXml(workingSet[i]));
        }
        
        if (NullChecker.isNotNullOrEmpty(enclosingElementName)) {
            ret = String.format("<%s xmlns='%s'>%s</%s>", enclosingElementName, defaultNamespace, resultString.toString(), enclosingElementName);
        }
        else {
            ret = resultString.toString();
        }
        
        return ret;
    }
}
