package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;

/**
 * A class to handle string-to-string mappings for DataManager
 *
 * @author Ry Bobko
 */
public class SimpleMappedDataTranslator implements DataTranslator {

	@Override
	public Object translate( Object input, Object result, Reference translation, DataQuery dataQuery ) {
		String inputstr = ( NullChecker.isNullOrEmpty( input )
				? ""
				: input.toString() );

		String value = translation.getProperty( inputstr );

		String ret = ( NullChecker.isNullOrEmpty( value ) ? inputstr : value );
		return ret;
	}
}
