package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;
import gov.va.med.nhin.adapter.utils.config.PropertiesType;
import gov.va.med.nhin.adapter.utils.config.PropertyType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author Jay Ward
 */
public class SimpleDedupeDataTranslator implements DataTranslator {
    
    private static final Logger logger = LoggerFactory.getLogger(SimpleDedupeDataTranslator.class.getName());

    @Override
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery) throws IOException {
        List src = new ArrayList();
        List mSrc = (input instanceof List) ? (List) input : Arrays.asList(new Object[] { input });
        HashMap<String, Object> map = new HashMap<String, Object>();
        String toName = translation.getProperty("toName");
        String extractPath = translation.getProperty("extractPath");
        String allowNulls = translation.getProperty("allowNullValues");
        String allowNullKeys = translation.getProperty("allowNullKeys");
        PropertiesType keys = translation.getProperties("uniqueKeys");
        
        for(Object i: mSrc) {
            Object j = getObjectFromItem(i, extractPath);
            if(NullChecker.isNullOrEmpty(j) && (NullChecker.isNullOrEmpty(allowNulls) || !allowNulls.equalsIgnoreCase("yes"))) { continue; }
            if(j instanceof List) { src.addAll((List)j); }
            else { src.add(j); }
        }
        
        for(Object i: src) {
            String key = getKeyFromObject(i, keys);
            if(NullChecker.isNullOrEmpty(key) && (NullChecker.isNullOrEmpty(allowNullKeys) || !allowNullKeys.equalsIgnoreCase("yes"))) { continue; }
            if(map.containsKey(key)) { continue; }
            map.put(key, i);
        }
        ArrayList<Object> ret = new ArrayList<Object>(map.values());
        if(input instanceof Map && NullChecker.isNotNullOrEmpty(toName) && !toName.equalsIgnoreCase("$self")) {
            ((Map) input).put(toName, ret);
            return input;
        }
        return ret;
    }

    private Object getObjectFromItem(Object i, String extractPath) {
        if(NullChecker.isNullOrEmpty(extractPath)) {
            return i;
        }
        try {
            return PropertyUtils.getProperty(i, extractPath);
        } catch (Exception ex) {
            logger.debug(extractPath, ex);
        }
        return null;
    }

    private String getKeyFromObject(Object i, PropertiesType keys) {
        String ret = "";
        if(NullChecker.isNullOrEmpty(keys)) { return i.toString(); }
        for(PropertyType key: keys.getProperty()) {
            if(!key.getName().equalsIgnoreCase("keyPath")) { continue; }
            try {
                Object data = PropertyUtils.getProperty(i, key.getValue());
                ret += data.toString();
            } catch (Exception ex) {
                logger.debug(key.getValue(), ex);
            }
        }
        return ret;
    }
    
}
