package gov.va.med.nhin.adapter.datamanager.translators;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.sts.webservice.ct.MapEntryValueListTransfer;
import gov.va.med.sts.webservice.ct.MapEntryValueTransfer;

public class SerializableMapEntryValueListTransfer extends MapEntryValueListTransfer
{
	private static final long serialVersionUID = -2941801419982932908L;

	private static final Logger logger = LoggerFactory.getLogger(SerializableMapEntryValueListTransfer.class.getName());

	public SerializableMapEntryValueListTransfer(MapEntryValueListTransfer mapEntryValueListTransfer)
	{
		setTotalNumberOfRecords(mapEntryValueListTransfer.getTotalNumberOfRecords());
		getMapEntryValues().addAll(mapEntryValueListTransfer.getMapEntryValues());
	}

	private void writeObject(ObjectOutputStream out) throws IOException
	{
		logger.debug("SerializableMapEntryValueListTransfer out stream {}", "writeObject");
		out.writeObject(getTotalNumberOfRecords());
		out.writeObject((Serializable) getMapEntryValues());
		logger.debug("SerializableMapEntryValueListTransfer out stream {}", "writeObject");
	}

	private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException
	{
		setTotalNumberOfRecords((Long) in.readObject());
		mapEntryValues = (List<MapEntryValueTransfer>) in.readObject();
	}
}
