/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.DataDate;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.datamanager.SmartHashMap;
import gov.va.med.nhin.adapter.utils.config.PropertiesType;
import gov.va.med.nhin.adapter.utils.config.PropertyType;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author PII
 */
public class SectionDateRangeTranslator implements DataTranslator<SmartHashMap> {
    
    private static final Logger logger = LoggerFactory.getLogger(SectionDateRangeTranslator.class.getName());
    static private final String DATE_FORMAT = "yyyyMMddHHmmss";

    @Override
    public SmartHashMap translate(Object input, Object result, Reference translation, DataQuery dataQuery) throws IOException {
        SmartHashMap r = new SmartHashMap();
        PropertiesType sections = translation.getReference().getProperties();
        for(PropertyType t : sections.getProperty()) {
            HashMap<String, DataDate> range;
            if(!r.containsKey(t.getName())) {
                range = new HashMap<String, DataDate>();
                range.put("low", null);
                range.put("high", null);
            } else {
                range = (HashMap<String, DataDate>) r.get(t.getName());
            }
            if(t.getProperties() == null) { 
                logger.debug(t.getName() + " is not configured with any lists, moving on.");
                continue; 
            }
            byList:
            for(PropertyType ls : t.getProperties().getProperty()) {
                if(!ls.getName().equals("list")) { continue; }
                try {
                    Object item = PropertyUtils.getProperty(input, ls.getValue());
                    if(item == null) {
                        logger.debug(ls.getValue()+" is null, moving on.");
                        continue;
                    }
                    if(!(item instanceof List)) {
                        logger.debug(ls.getValue()+" is not a list ("+item.getClass().toString()+"), moving on.");
                        continue;
                    }
                    for(Object i : (List) item) {
                        if(!(i instanceof SmartHashMap)) {
                            logger.debug("Item is not a SmartHashMap, moving on.");
                            continue;
                        }
                        SmartHashMap j = (SmartHashMap) i;
                        try {
                            setValue(false, j, range);
                            setValue(true, j, range);
                        } catch(Exception ex) {
                            logger.error("Elements in "+ls.getValue()+" list do not have start/stop times, moving to next list.", ex);
                            continue byList;
                        }
                    }
                } catch(Exception ex) {
                    logger.error("Unable to access "+ls.getValue()+" in input.", ex);
                    continue;
                }
            }
            r.put(t.getName(), range);
        }
        ((SmartHashMap) input).put("sectionDateRanges", r);
        return (SmartHashMap) input;
    }
    private void setValue(boolean isHigh, SmartHashMap object, HashMap<String, DataDate> range) throws IllegalAccessException, InvocationTargetException, InvocationTargetException, NoSuchMethodException {
        String direction = (isHigh ? "high" : "low");
        String dirQuery  = (isHigh ? "queryEnd" : "queryStart");
        Object date = PropertyUtils.getProperty(object, dirQuery);
        if(date instanceof Date) {
            if(range.get(direction) == null || ! (range.get(direction) instanceof Date)) {
                date = new DataDate(((Date)date).getTime(), DATE_FORMAT);
                range.put(direction, (DataDate)date);
            } else {
                Date d = (DataDate) range.get(direction);
                if((isHigh && d.before((DataDate)date)) || (!isHigh && d.after((DataDate)date))) {
                    date = new DataDate(((Date)date).getTime(), DATE_FORMAT);
                    range.put(direction, (DataDate)date);
                }
            }
        }
    }
}
