package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;
import gov.va.med.nhin.adapter.utils.SHA1Hash;

/**
 *
 * @author David Vazquez
 */
public class SHA1HashDataTranslator implements DataTranslator<String>
{
	@Override
	public String translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		String ret = null;

		if(!NullChecker.isNullOrEmpty(input))
		{
			ret = SHA1Hash.getHash((byte[]) input);
		}

		return ret;
	}
}
