/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.datamanager.translators;

import java.util.regex.*;

import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.utils.*;

/**
 *
 * @author PII
 */
public class ReplaceAllDataTranslator implements DataTranslator
{
    @Override
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
    {
        String ret = null;
        
        if (input != null) {
            String regex = translation.getProperty("regex");
            if (NullChecker.isNullOrEmpty(regex)) {
                throw new DataManagerException("regex property must be set.");
            }
            String replacement = translation.getProperty("replacement");
            // we check for null instead of isNullOrEmpty so that we can replace regex with empty strings.
            if (replacement == null) {
                throw new DataManagerException("replacement property must be set.");
            }
            if (!(input instanceof String)) {
                throw new DataManagerException("input must be of type java.lang.String.");
            }
            String inputAsString = (String)input;
            ret = inputAsString.replaceAll(regex, Matcher.quoteReplacement(replacement));
        }
        
        return ret;
   }
}
