package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;

/**
 *
 * @author David Vazquez
 */
public class RemoveEmptyQuotesDataTranslator implements DataTranslator<String>
{
	@Override
	public String translate(Object o, Object o1, Reference rfrnc, DataQuery dq)
	{
		String ret = null;

		if(o != null)
		{
			if(!(o instanceof java.lang.String))
			{
				throw new DataManagerException("input must be of type java.lang.String");
			}

			String str = (String) o;
			if(str.equals("\"\""))
			{
				ret = "";
			}
			else
			{
				ret = str;
			}
		}

		return ret;
	}
}
