/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.datamanager.translators;

import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author jay
 */
public class ReflectorTranslator implements DataTranslator<Object> {

    @Override
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery) throws IOException {
        List<Object> ret = new ArrayList();
        
        String fromName = translation.getProperty("fromData");

        if(StringUtils.isBlank(fromName))
        {
            throw new DataManagerException("fromData property must be set.");
        }
        List<Object> fromList = ((input instanceof List) ? (List) input: Arrays.asList(new Object[] { input }));
            
        for(Object j : (List) fromList) {
            try {
                Object i = PropertyUtils.getProperty(j, fromName);
                if(i instanceof List) {
                    ret.addAll((List) i);
                } else if(NullChecker.isNotNullOrEmpty(i)) {
                    ret.add(i);
                }
            } catch (IllegalAccessException ex) {
                Logger.getLogger(ReflectorTranslator.class.getName()).log(Level.SEVERE, null, ex);
            } catch (InvocationTargetException ex) {
                Logger.getLogger(ReflectorTranslator.class.getName()).log(Level.SEVERE, null, ex);
            } catch (NoSuchMethodException ex) {
                Logger.getLogger(ReflectorTranslator.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        
        return ret;
    }
    
}
