/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.datamanager.SmartHashMap;
import gov.va.med.nhin.adapter.utils.NullChecker;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.beanutils.PropertyUtils;

/**
 *
 * @author Jay Ward
 */
public class PreferredLanguage implements DataTranslator<Object> {
    
    private String facilityField = "facilityNumber";
    private String preferredFacilityField = "patientPreferredFacilityNumber";
    private String preferredFacility;
    private String codeField = "code";

    @Override
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery) throws IOException {
        setupConfigs(translation, dataQuery);
        SmartHashMap ret = initializeRet();
        if(input instanceof List && ((List<SmartHashMap>) input).size() > 0) {
            ret.replace("preferred", getPreferredLanguage((List<SmartHashMap>)input));
            for (Object i:((List<SmartHashMap>)input)) {
                if (!isSame(i, ret.get("preferred"))) {
                    ret.put("others", i);
                }
            }
        }
        return Arrays.asList(new Object[]{ret});
    }
    private void setupConfigs(Reference translation, DataQuery dataQuery) {        
        if(NullChecker.isNotNullOrEmpty(translation.getProperty("facilityField"))) { this.facilityField =  translation.getProperty("facilityField"); }
        if(NullChecker.isNotNullOrEmpty(translation.getProperty("preferredFacilityField"))) { this.preferredFacilityField =  translation.getProperty("preferredFacilityField"); }
        if(NullChecker.isNotNullOrEmpty(translation.getProperty("codeField"))) { this.codeField =  translation.getProperty("codeField"); }
        setPreferredFacility(dataQuery);
    }

    private void setPreferredFacility(DataQuery dataQuery) {
        String field = preferredFacilityField;
        preferredFacility = "";
        String subField = "";
        if(field.contains(".")) {
            String[] s = field.split("\\.", 2);
            field = s[0];
            subField = s[1];
        }
        Object obj = dataQuery.getParameter(field);
        List l;
        if(obj instanceof List) {
            l = (List) obj;
        } else {
            l = Arrays.asList(new Object[] { obj });
        }
        for(Object i : l) {
            if(subField.length() > 0) {
                try {
                    Object me = PropertyUtils.getProperty(i, subField);
                    if(me instanceof String) {
                        preferredFacility = (String) me;
                    }
                } catch (Exception ex) {
                    Logger.getLogger(ImmunizationsFilter.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                if(i instanceof String) {
                    preferredFacility = (String) i;
                }
            }
        }
    }

    private SmartHashMap getPreferredLanguage(List<SmartHashMap> list) {
        if (NullChecker.isNullOrEmpty(preferredFacility)) {
            return (SmartHashMap) list.get(0);
        }
        for (SmartHashMap i:list) {
            try {
                Object facilityNumber = PropertyUtils.getProperty(i, facilityField);
                if (facilityNumber instanceof String && preferredFacility.equalsIgnoreCase((String)facilityNumber)) {
                    return i;
                }
            } catch (Exception ex) {
                Logger.getLogger(PreferredLanguage.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return list.get(0);
    }

    private SmartHashMap initializeRet() {
        SmartHashMap ret = new SmartHashMap();
        ret.put("preferred", null);
        ret.put("others", new ArrayList());
        return ret;
    }

    private boolean isSame(Object i, Object preferred) {
        Object icode = "";
        Object preferredCode = "";
        try {
            icode = PropertyUtils.getProperty(i, codeField);
        } catch (Exception ex) {
            Logger.getLogger(PreferredLanguage.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            preferredCode = PropertyUtils.getProperty(preferred, codeField);
        } catch (Exception ex) {
            Logger.getLogger(PreferredLanguage.class.getName()).log(Level.SEVERE, null, ex);
        }
            
        return (icode.toString().equalsIgnoreCase(preferredCode.toString()));
        
    }
}
