package gov.va.med.nhin.adapter.datamanager.translators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;
import gov.va.med.nhin.adapter.utils.Utils;

/**
 *
 * @author David Vazquez
 */
public class MostRecentDateDataTranslator implements DataTranslator
{
	public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		List ret = null;

		if(input != null)
		{
			if(!Utils.isCollection(input))
			{
				throw new DataManagerException("input must be a collection.");
			}

			ret = new ArrayList();
			String sortFields = translation.getProperty("sortFields");

			if(NullChecker.isNullOrEmpty(sortFields))
			{
				throw new DataManagerException("Property sortFields is required.");
			}

			final String[] sortFieldsArray = sortFields.split(",");
			List sortedInput = new ArrayList();

			try
			{
				for(int i = 0; i < Utils.getCollectionLength(input); ++i)
				{
					sortedInput.add(PropertyUtils.getIndexedProperty(input, "", i));
				}

				Collections.sort(sortedInput, new java.util.Comparator()
				{
					public int compare(Object o1, Object o2)
					{
						int ret = 0;
						int i = 0;

						for(i = 0; i < sortFieldsArray.length && ret == 0; ++i)
						{
							Comparable left = (Comparable) getProperty(o1, sortFieldsArray[i]);
							Comparable right = (Comparable) getProperty(o2, sortFieldsArray[i]);
							if(left != null && right != null)
							{
								ret = left.compareTo(right);
							}
							else if(left == null)
							{
								ret = -1;
							}
							else
							{
								ret = 1;
							}
						}

						if(i == sortFieldsArray.length)
						{
							ret *= -1;
						}

						return ret;
					}
				});

				if(sortFieldsArray.length == 1)
				{
					ret.add(sortedInput.get(0));
				}
				else
				{
					Object workingObj = null;

					for(Object obj : sortedInput)
					{
						if(workingObj == null)
						{
							workingObj = obj;
							ret.add(obj);
						}
						else
						{
							int i = 0;
							for(i = 0; i < sortFieldsArray.length - 1 && PropertyUtils.getProperty(obj, sortFieldsArray[i]).equals(PropertyUtils.getProperty(workingObj, sortFieldsArray[i])); ++i)
								;
							if(i < sortFieldsArray.length - 1)
							{
								ret.add(obj);
								workingObj = obj;
							}
						}
					}
				}
			}
			catch(Exception e)
			{
				throw new DataManagerException("An error occurred retrieving item from collection.", e);
			}
		}

		return ret;
	}

	private Object getProperty(Object bean, String property)
	{
		try
		{
			return PropertyUtils.getProperty(bean, property);
		}
		catch(Exception e)
		{
			throw new DataManagerException("An error occurred retrieving item from getProperty().", e);
		}
	}
}
