package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;

/**
 *
 * @author PII
 */
public class FirstNotBlankDataTranslator implements DataTranslator<Object>
{
	@Override
	public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		Object ret = null;
		String propertyNames = translation.getProperty("propertyNames");

		if(NullChecker.isNullOrEmpty(propertyNames))
		{
			throw new DataManagerException("proertyNames property must be set.");
		}

		for(String propertyName : propertyNames.split(","))
		{
			Object value = translation.getValue(propertyName);
			if(NullChecker.isNotNullOrEmpty(value))
			{
				ret = value;
				break;
			}
		}

		return ret;
	}
}
