package gov.va.med.nhin.adapter.datamanager.translators;

import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;
import gov.va.med.nhin.adapter.utils.Utils;
import java.lang.reflect.InvocationTargetException;

/**
 *
 * @author David Vazquez
 */
public class FilterDataTranslator implements DataTranslator<Object>
{
	private static final Logger logger = LoggerFactory.getLogger(FilterDataTranslator.class.getName());

	@Override
	public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		// CCR177986-logging update
		logger.debug("translate input are {} {} {} {}", input, result, translation, dataQuery);

		Object ret = null;
		String whereProperty = translation.getProperty("whereProperty");
		String wherePropertyValue = translation.getProperty("wherePropertyValue");
		String resultProperty = translation.getProperty("resultProperty");
                String[] whereValues = wherePropertyValue.split(",");

		logger.debug("whereProperty={}", whereProperty);
		logger.debug("wherePropertyValue={}", wherePropertyValue);
		logger.debug("resultProperty={}", resultProperty);

		try
		{
			if(input != null)
			{
				if(!Utils.isCollection(input))
				{
					throw new DataManagerException("FilterDataTranslator-input must be a collection.");
				}
                                eachItemInCollection:
				for(int i = 0; i < Utils.getCollectionLength(input); ++i)
				{
					Object obj = PropertyUtils.getIndexedProperty(input, "", i);
					Object value = PropertyUtils.getProperty(obj, whereProperty);
					logger.debug("value {} =", value);
                                        for(String whereValue: whereValues) {
                                            if(NullChecker.isNotNullOrEmpty(value) && value.equals(whereValue))
                                            {
                                                    ret = NullChecker.isNotNullOrEmpty(resultProperty) ? PropertyUtils.getProperty(obj, resultProperty) : obj;
                                                    logger.debug("FilterDataTranslator ret {} ", ret);
                                                    break eachItemInCollection;
                                            }
                                        }
				}
			}
		}
		catch(DataManagerException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e)
		{
			throw new DataManagerException("Exception occurred in FilterDataTranslator", e);
		}

		return ret;
	}
}
