package gov.va.med.nhin.adapter.datamanager.translators;

import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.datamanager.SmartHashMap;
import gov.va.med.nhin.adapter.datamanager.internalApp.InternalAppFilter;
import gov.va.med.nhin.adapter.datamanager.internalApp.InternalAppFilterObj;
import gov.va.med.nhin.adapter.utils.NullChecker;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * @author PII
 *
 * Performs all the additional filtering based on the AdditionalParameters
 * passed.
 *
 */
public class CCDAAdditionalFilters implements DataTranslator<Object>
{
    @SuppressWarnings("unchecked")
    @Override
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
    {
        Object filterObj = dataQuery.getParameter("AdditionalFilters");
        if (filterObj instanceof Map) {
            String sectionFromName = (String) translation.getProperty("section");
            if (StringUtils.isNotBlank(sectionFromName)) {
                Map<String, List<InternalAppFilterObj>> map = (Map<String, List<InternalAppFilterObj>>) filterObj;
                Map<String, List<InternalAppFilterObj>> smallMap = new HashMap<>();
                Object fomInput = input;
                if (StringUtils.contains(sectionFromName, ",")) {
                    // Need to process a list of values.
                    String[] names = StringUtils.split(sectionFromName, ",");
                    for (String name : names) {
                        List<InternalAppFilterObj> list = map.get(name);
                        if (CollectionUtils.isNotEmpty(list)) {
                            smallMap.put(name, list);
                        }
                    }
                }
                else {
                    // Just need to process a single value.
                    if (map.containsKey(sectionFromName)) {
                        smallMap.put(sectionFromName, map.get(sectionFromName));
                        if (NullChecker.isNotNullOrEmpty(translation.getProperty("mapIt"))) {
                            Map inputAsMap = new SmartHashMap();
                            inputAsMap.put(sectionFromName, input);
                            fomInput = inputAsMap;
                        }
                    }
                }
                
                filterObjectsMap(smallMap, fomInput);
            }
            else {
                // Processing all available filters.
                filterObjectsMap((Map<String, List<InternalAppFilterObj>>) filterObj, input);
            }
        }
        return input;
    }

    private void filterObjectsMap(final Map<String, List<InternalAppFilterObj>> map, Object input)
    {
        if (!map.isEmpty() && input instanceof SmartHashMap) {
            InternalAppFilter appFilter = new InternalAppFilter();
            appFilter.filterObjects(map, SmartHashMap.class.cast(input));
        }
    }
}
