package gov.va.med.nhin.adapter.datamanager.translators;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;

/**
 *
 * @author 575914
 */
public class AssessmentTotalTranslator implements DataTranslator<String>
{
	private static final Logger logger = LoggerFactory.getLogger(AssessmentTotalTranslator.class.getName());

	@Override
	public String translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		String fields = translation.getProperty("fields");

		String ret = null;

		try
		{
			int total = 0;
			int i = 0;
			for(String field : fields.split(","))
			{
				try
				{
					Object value = translation.getValue(field);
					total += Integer.parseInt((String) value);
				}
				catch(NumberFormatException e)
				{
					logger.error("Field {} is not an integer: {}", i, e);
				}

				i++;
			}

			ret = String.valueOf(total);

		}
		catch(RuntimeException t)
		{
			throw new DataManagerException("There was an error.", t);
		}

		return ret;
	}
}
