package gov.va.med.nhin.adapter.datamanager.translators;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.DataTranslator;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;
import gov.va.med.nhin.adapter.utils.Utils;

public class AppendAllDataTranslator implements DataTranslator
{
	private static final Logger logger = LoggerFactory.getLogger(AppendAllDataTranslator.class.getName());

	@Override
	public String translate(Object input, Object result, Reference translation, DataQuery dataQuery)
	{
		String ret = null;
		String whereProperty = translation.getProperty("whereProperty");

		try
		{
			if(input != null)
			{
				if(!Utils.isCollection(input))
				{
					throw new RuntimeException("input must be a collection.");
				}

				String appendString = "";
				for(int i = 0; i < Utils.getCollectionLength(input); ++i)
				{
					Object obj = PropertyUtils.getIndexedProperty(input, "", i);

					if(obj instanceof ArrayList)
					{
						for(int j = 0; j < Utils.getCollectionLength(obj); ++j)
						{
							Object listObj = PropertyUtils.getIndexedProperty(obj, "", j);
							Object value = PropertyUtils.getProperty(listObj, whereProperty);

							if(NullChecker.isNotNullOrEmpty(value))
							{
								appendString = appendString + (String) value;
							}
						}
					}
					else
					{
						Object value = PropertyUtils.getProperty(obj, whereProperty);

						if(NullChecker.isNotNullOrEmpty(value))
						{
							appendString = appendString + (String) value;
						}
					}
				}

				ret = appendString;
			}
		}
		catch(RuntimeException | IllegalAccessException | InvocationTargetException | NoSuchMethodException t)
		{
			throw new DataManagerException("There was an error.", t);
		}

		return ret;
	}
}
