package gov.va.med.nhin.adapter.datamanager.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import gov.va.med.nhin.adapter.datamanager.DataParser;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.Reference;

/**
 *
 * @author David Vazquez
 */
public class DetailDataParser implements DataParser
{
	public List parse(List dataResults, Reference parserType, DataQuery dataQuery)
	{
		List ret = new ArrayList<Map>();
		String delimiter = parserType.getProperty("delimiter");

		HashMap<String, String> record = new HashMap<String, String>();
		String results = (String) dataResults.get(0);
		String currentKey = null;
		StringBuffer currentValue = new StringBuffer();
		String[] lines = results.split("\n");
		for(String line : lines)
		{
			String[] parts = line.split(delimiter, -1);
			if(parts.length >= 2)
			{
				String key;
				StringBuffer value = new StringBuffer();
				key = parts[0].trim();
				for(int i = 1; i < parts.length; ++i)
				{
					if(value.length() > 0)
					{
						value.append(delimiter);
					}
					value.append(parts[i]);
				}

				if(currentKey != null && key.length() > 0 && !key.equals(currentKey))
				{
					record.put(currentKey, currentValue.toString());
					currentValue.delete(0, currentValue.length());
					currentValue.append(value.toString().trim());
				}

				currentKey = key.length() > 0 ? key : currentKey;
			}
			else if(parts.length == 1 && parts[0].trim().length() > 0)
			{
				if(currentKey != null)
				{
					if(currentValue.length() > 0)
					{
						currentValue.append('\n');
					}
					currentValue.append(parts[0].trim());
				}
			}
		}

		//if(currentValue != null && currentKey != null) //Unnecessary check for null.currentValue is always not null.
                if(currentKey != null)
		{
			if(currentValue.length() > 0 && currentKey.length() > 0)
			{
				record.put(currentKey, currentValue.toString());
			}
		}

		ret.add(record);

		return ret;
	}
}
