package gov.va.med.nhin.adapter.datamanager.filters;

import java.util.List;
import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.nhin.adapter.datamanager.DataFilter;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.Reference;

/**
 *
 * @author David Vazquez
 */
public class OrDataFilter implements DataFilter
{
	private static final Logger logger = LoggerFactory.getLogger(OrDataFilter.class.getName());

	public boolean test(Object result, List results, Reference filterType, DataQuery dataQuery)
	{
		try
		{
			String firstOperand = filterType.getProperty("firstOperand");
			String secondOperand = filterType.getProperty("secondOperand");

			logger.debug("firstOperand: {} secondOperand: {}", firstOperand, secondOperand);

			return firstOperand.toUpperCase(Locale.ENGLISH).equals("TRUE") || secondOperand.toUpperCase(Locale.ENGLISH).equals("TRUE");
		}
		catch(Throwable t)
		{
			throw new RuntimeException("An error occurred when processing filter.", t);
		}
	}
}
