package gov.va.med.nhin.adapter.datamanager.filters;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.med.nhin.adapter.datamanager.DataFilter;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.Reference;

public class NotContainsDataFilter implements DataFilter {

	private static final Logger logger = LoggerFactory.getLogger( NotContainsDataFilter.class.getName() );
	private final ContainsDataFilter CDF = new ContainsDataFilter();

	@Override
	public boolean test( Object result, List results, Reference filterType, DataQuery dataQuery ) {
		boolean contains = CDF.test( result, results, filterType, dataQuery );
		logger.debug( "not contains: {}", !contains );
		return !contains;
	}
}
