package gov.va.med.nhin.adapter.datamanager.filters;

import java.util.Date;
import java.util.List;
import java.util.Locale;

import org.apache.commons.beanutils.PropertyUtils;

import gov.va.med.nhin.adapter.datamanager.DataFilter;
import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.datamanager.DataQuery;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.utils.NullChecker;
import org.apache.commons.lang3.time.DateUtils;

/**
 *
 * @author David Vazquez
 */
public class DateBetweenDataFilter implements DataFilter
{
	public boolean test(Object result, List results, Reference filterType, DataQuery dataQuery)
	{
		boolean ret = false;

		try
		{
			String beginDateName = filterType.getProperty("beginDateName");
			String endDateName = filterType.getProperty("endDateName");
			String valueName = filterType.getProperty("valueName");
			String includeEndDateString = filterType.getProperty("includeEndDate");
                        String dayGranularity = filterType.getProperty("useDayGranularity");
			Date beginDate = (Date) dataQuery.getParameter(beginDateName);
			Date endDate = (Date) dataQuery.getParameter(endDateName);
			Date value = (Date) PropertyUtils.getProperty(result, valueName);
                        boolean useDayGranularity = NullChecker.isNotNullOrEmpty(dayGranularity) && dayGranularity.toUpperCase(Locale.ENGLISH).equals("TRUE");
			boolean includeEndDate = NullChecker.isNotNullOrEmpty(includeEndDateString) && includeEndDateString.toUpperCase(Locale.ENGLISH).equals("TRUE");

			ret = (
                            NullChecker.isNullOrEmpty(beginDate) 
                            || value.after(beginDate)
                            || (!useDayGranularity && value.equals(beginDate))
                            || (useDayGranularity && DateUtils.isSameDay(beginDate, value))
                        ) && (
                            NullChecker.isNullOrEmpty(endDate) 
                            || value.before(endDate)
                            || includeEndDate && (
                                (!useDayGranularity && value.equals(endDate))
                                || (useDayGranularity && DateUtils.isSameDay(endDate, value))
                            )
                        );
		}
		catch(Exception e)
		{
			throw new DataManagerException("There was an error during a filter test.", e);
		}

		return ret;
	}
}
