package gov.va.med.nhin.adapter.datamanager.filters;

import java.util.List;
import java.util.ListIterator;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import gov.va.med.nhin.adapter.datamanager.SmartHashMap;
import gov.va.med.nhin.adapter.utils.NullChecker;

public class C32RemoveCCDADataFilter
{
	// Performs in place filtering of additional C-CDA elements.
	public static void filterObjects(Object results)
	{
		if(results != null)
		{
			if(results instanceof SmartHashMap)
			{
				SmartHashMap smartMap = (SmartHashMap) results;
				filterAllergyItems((List<SmartHashMap>) smartMap.get("allergies"));
			}
		}
	}

	public static void filterAllergyItems(List<SmartHashMap> allergies)
	{
		if(allergies != null && CollectionUtils.isNotEmpty(allergies))
		{
			for(ListIterator<SmartHashMap> iter = allergies.listIterator(); iter.hasNext();)
			{
				SmartHashMap allergy = iter.next();
				if(NullChecker.isNotNullOrEmpty((String) allergy.get("assessment")))
				{
					iter.remove();
				}
			}
		}
	}
}
