package gov.va.med.nhin.adapter.datamanager.fieldgenerators;

import java.util.Date;

import gov.va.med.nhin.adapter.datamanager.DataFieldGenerator;
import gov.va.med.nhin.adapter.datamanager.DataManagerException;
import gov.va.med.nhin.adapter.utils.NullChecker;
import java.util.Calendar;
import java.util.GregorianCalendar;

/**
 *
 * @author David Vazquez
 *
 * CurrentTimeDataFieldGenerator provides a Data object for use as a default
 * value in query parameters and results. The returned Date object optionally
 * can be adjusted by providing an adjustment amount and scale. The first
 * position in the array specifies the amount by which to offset the date and
 * the second position in the array specifies the scale (Y=Year, M=Month,
 * D=Day). The default scale is Y.
 */
public class CurrentTimeDataFieldGenerator implements DataFieldGenerator
{
    /**
     *
     * @param params - optional array of strings which specifies a date
     * adjustment.
     * @return Date object.
     */
    @Override
    public Object generate(String[] params)
    {
        Date ret = new Date();

        if (NullChecker.isNotNullOrEmpty(params)) {
            if (params.length >= 1) {
                try {
                    int amount = Integer.parseInt(params[0]);
                    String scale = "Y";

                    if (params.length >= 2) {
                        scale = params[1];
                        if (!isScaleValid(scale)) {
                            throw new DataManagerException("scale is not valid.");
                        }
                    }
                    
                    int f = 0;
                    if (scale.equalsIgnoreCase("D")) {
                        f = Calendar.DATE;
                    }
                    else if (scale.equalsIgnoreCase("M")) {
                        f = Calendar.MONTH;
                    }
                    else if (scale.equalsIgnoreCase("Y")) {
                        f = Calendar.YEAR;
                    }

                    Calendar cal = GregorianCalendar.getInstance();
                    cal.setTime((Date) ret);
                    cal.add(f, amount);
                    ret = cal.getTime();
                }
                catch (NumberFormatException nfe) {
                    throw new DataManagerException("amount is not an integer.", nfe);
                }
            }
        }

        return ret;
    }

    private boolean isScaleValid(String scale)
    {
        return scale.equalsIgnoreCase("Y")
                || scale.equalsIgnoreCase("M")
                || scale.equalsIgnoreCase("D");
    }
}
